/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.toolkit.oasv.FactoryOptions;
import org.apache.servicecomb.toolkit.oasv.style.validator.response.ResponseHeadersKeysCaseValidator;
import org.apache.servicecomb.toolkit.oasv.validation.api.ResponseValidator;
import org.apache.servicecomb.toolkit.oasv.validation.factory.HeaderValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.MediaTypeValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.ResponseValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.response.ResponseContentValidator;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.response.ResponseHeadersValuesValidator;
import org.springframework.stereotype.Component;

@Component
public class DefaultResponseValidatorFactory
implements ResponseValidatorFactory {
    private final MediaTypeValidatorFactory mediaTypeValidatorFactory;
    private final HeaderValidatorFactory headerValidatorFactory;

    public DefaultResponseValidatorFactory(MediaTypeValidatorFactory mediaTypeValidatorFactory, HeaderValidatorFactory headerValidatorFactory) {
        this.mediaTypeValidatorFactory = mediaTypeValidatorFactory;
        this.headerValidatorFactory = headerValidatorFactory;
    }

    public List<ResponseValidator> create(FactoryOptions options) {
        ArrayList<ResponseValidator> validators = new ArrayList<ResponseValidator>();
        validators.add((ResponseValidator)new ResponseContentValidator(this.mediaTypeValidatorFactory.create(options)));
        validators.add((ResponseValidator)new ResponseHeadersValuesValidator(this.headerValidatorFactory.create(options)));
        this.addResponseHeadersKeysCaseValidator(validators, options);
        return Collections.unmodifiableList(validators);
    }

    private void addResponseHeadersKeysCaseValidator(List<ResponseValidator> validators, FactoryOptions options) {
        String expectedCase = options.getString("response.headers.key.case");
        if (expectedCase != null) {
            validators.add((ResponseValidator)new ResponseHeadersKeysCaseValidator(expectedCase));
        }
    }
}

