/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.validator.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectType;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasValidationContext;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasViolation;
import org.apache.servicecomb.toolkit.oasv.validation.api.OpenApiValidator;

public class OpenApiSecuritySizeEqValidator
implements OpenApiValidator {
    public static final String CONFIG_KEY = "openAPI.security.size.eq";
    public static final String ERROR = "size must be == ";
    private final int expectedSize;

    public OpenApiSecuritySizeEqValidator(int expectedSize) {
        this.expectedSize = expectedSize;
    }

    public List<OasViolation> validate(OasValidationContext context, OasObjectPropertyLocation location, OpenAPI openAPI) {
        int size = CollectionUtils.size((Object)openAPI.getSecurity());
        if (size != this.expectedSize) {
            return Collections.singletonList(new OasViolation(location.property("security", OasObjectType.SECURITY_REQUIREMENT), ERROR + this.expectedSize));
        }
        return Collections.emptyList();
    }
}

