/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.validator.parameter;

import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.util.StringCaseUtils;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasValidationContext;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasViolation;
import org.apache.servicecomb.toolkit.oasv.validation.api.ParameterValidator;

public class ParameterNameCookieCaseValidator
implements ParameterValidator {
    public static final String CONFIG_KEY = "parameter.name.cookie.case";
    public static final String ERROR = "Must be ";
    private final String expectedCase;

    public ParameterNameCookieCaseValidator(String expectedCase) {
        this.expectedCase = expectedCase;
    }

    public List<OasViolation> validate(OasValidationContext context, OasObjectPropertyLocation location, Parameter oasObject) {
        if (StringUtils.isNotBlank((CharSequence)oasObject.get$ref())) {
            return Collections.emptyList();
        }
        if (!"cookie".equalsIgnoreCase(oasObject.getIn())) {
            return Collections.emptyList();
        }
        if (!StringCaseUtils.isMatchCase((String)this.expectedCase, (String)oasObject.getName())) {
            return Collections.singletonList(new OasViolation(location.property("name"), ERROR + this.expectedCase));
        }
        return Collections.emptyList();
    }
}

