/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.common;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.servicecomb.toolkit.common.Comparison;
import org.eclipse.jgit.diff.DiffFormatter;

public class SplitDiffFormatter
extends DiffFormatter {
    private int radius = 3;
    private final OutputStream out;
    private static final String noNewLine = "\nthis is end of compare\n";
    private static String outputFormat = "%-20s";
    private static String numberFormat = "%-4s";

    public SplitDiffFormatter(OutputStream out) {
        super(out);
        this.out = out;
    }

    public void format(List<Comparison> comparisons, String source, String dest) throws IOException {
        outputFormat = "%-" + (this.getMaxLineSize(source) + 10) + "s";
        List<String> sourceLines = this.readStringAsLines(source);
        List<String> destLines = this.readStringAsLines(dest);
        int currentIndex = 0;
        while (currentIndex < comparisons.size()) {
            Comparison currentComparison = comparisons.get(currentIndex);
            int endIndex = this.findOutputEndIndex(comparisons, currentIndex);
            Comparison endComparison = comparisons.get(endIndex);
            int originalBegin = (int)Math.max(0L, (long)currentComparison.originalPointBegin - (long)this.radius);
            int destinationBegin = (int)Math.max(0L, (long)currentComparison.destinationPointBegin - (long)this.radius);
            int originalEnd = (int)Math.min((long)sourceLines.size(), (long)endComparison.originalPointEnd + (long)this.radius);
            int destinationEnd = (int)Math.min((long)destLines.size(), (long)endComparison.destinationPointEnd + (long)this.radius);
            this.writeHunkHeader(originalBegin, originalEnd, destinationBegin, destinationEnd);
            while (originalBegin < originalEnd || destinationBegin < destinationEnd) {
                if (originalBegin < currentComparison.originalPointBegin || endIndex + 1 < currentIndex) {
                    this.writeContextLine(sourceLines, originalBegin, destLines, destinationBegin);
                    ++originalBegin;
                    ++destinationBegin;
                } else if (originalBegin < currentComparison.originalPointEnd) {
                    if (destinationBegin < currentComparison.destinationPointEnd) {
                        this.writeReplaceLine(sourceLines, originalBegin, destLines, destinationBegin);
                        ++destinationBegin;
                    } else {
                        this.writeRemovedLine(sourceLines, originalBegin, destLines, destinationBegin);
                    }
                    ++originalBegin;
                } else if (destinationBegin < currentComparison.destinationPointEnd) {
                    this.writeAddedLine(sourceLines, originalBegin, destLines, destinationBegin);
                    ++destinationBegin;
                }
                if (!SplitDiffFormatter.end(currentComparison, originalBegin, destinationBegin) || ++currentIndex >= comparisons.size()) continue;
                currentComparison = comparisons.get(currentIndex);
            }
            this.writeLine(noNewLine);
        }
    }

    public int getMaxLineSize(String text) {
        int[] maxLen = new int[]{0};
        this.readStringAsLines(text).forEach(line -> {
            int temp = line.length();
            if (temp > maxLen[0]) {
                maxLen[0] = temp;
            }
        });
        return maxLen[0];
    }

    private List<String> readStringAsLines(String text) {
        return Arrays.asList(text.split("\\r?\\n"));
    }

    protected void writeReplaceLine(List<String> text, int line, List<String> textB, int bCur) throws IOException {
        this.writeLine(this.buildFormatLineLeft(text, line, " -") + this.buildFormatLineRight(textB, bCur, " +") + "\n");
    }

    protected void writeContextLine(List<String> text, int line, List<String> textB, int bCur) throws IOException {
        this.writeLine(this.buildFormatLineLeft(text, line, "  ") + this.buildFormatLineRight(textB, bCur, "  ") + "\n");
    }

    protected void writeRemovedLine(List<String> text, int line, List<String> textB, int bCur) throws IOException {
        this.writeLine(this.buildFormatLineLeft(text, line, " -") + "\n");
    }

    protected void writeAddedLine(List<String> text, int line, List<String> textB, int bCur) throws IOException {
        this.writeLine(String.format(numberFormat, " ") + String.format(outputFormat, " ") + this.buildFormatLineRight(textB, bCur, " +") + "\n");
    }

    protected void writeLine(String content) throws IOException {
        this.out.write(content.getBytes());
    }

    private String buildFormatLineLeft(List<String> text, int line, String prefix) {
        return String.format(numberFormat, line + 1) + String.format(outputFormat, prefix + text.get(line));
    }

    private String buildFormatLineRight(List<String> text, int line, String prefix) {
        return String.format(numberFormat, line + 1) + String.format(this.getOutputFormat(text.get(line).length()), prefix + text.get(line));
    }

    private String getOutputFormat(int len) {
        return "%-" + len + "s";
    }

    private static boolean end(Comparison edit, int a, int b) {
        return edit.originalPointEnd <= a && edit.destinationPointEnd <= b;
    }

    private int findOutputEndIndex(List<Comparison> edits, int i) {
        int end;
        for (end = i + 1; end < edits.size() && (this.isOriginalEnd(edits, end) || this.isDestinationEnd(edits, end)); ++end) {
        }
        return end - 1;
    }

    private boolean isOriginalEnd(List<Comparison> e, int i) {
        return e.get((int)i).originalPointBegin - e.get((int)(i - 1)).originalPointEnd <= 2 * this.radius;
    }

    private boolean isDestinationEnd(List<Comparison> e, int i) {
        return e.get((int)i).destinationPointBegin - e.get((int)(i - 1)).destinationPointEnd <= 2 * this.radius;
    }
}

