/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.InvalidClassException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.internal.shared.CoordinateOperations;
import org.apache.sis.referencing.internal.shared.ExtendedPrecisionMatrix;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.CartesianToPolar;
import org.apache.sis.referencing.operation.transform.CartesianToSpherical;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.PolarToCartesian;
import org.apache.sis.referencing.operation.transform.SphericalToCartesian;
import org.apache.sis.referencing.operation.transform.TransformJoiner;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

abstract class CoordinateSystemTransform
extends AbstractMathTransform {
    private final int dimension;
    private final int[] linearDimensions;
    private final byte linearTransformPosition;
    final transient OperationMethod method;
    final transient OperationMethod method3D;
    final transient ContextualParameters context;
    private volatile transient MathTransform complete;
    private volatile transient MathTransform passthrough;

    CoordinateSystemTransform(String method, String method3D, int dimension, int[] linearDimensions, byte linearTransformPosition) {
        this.dimension = dimension;
        this.linearDimensions = linearDimensions;
        this.linearTransformPosition = linearTransformPosition;
        this.method = CoordinateSystemTransform.method(method);
        this.method3D = method3D != null ? CoordinateSystemTransform.method(method3D) : this.method;
        this.context = new ContextualParameters(this.method.getParameters(), dimension, dimension);
    }

    private static OperationMethod method(String name) {
        Map<String, ImmutableIdentifier> properties = Map.of("name", new ImmutableIdentifier(Citations.SIS, "SIS", name));
        DefaultParameterDescriptorGroup descriptor = new DefaultParameterDescriptorGroup(properties, 1, 1, new GeneralParameterDescriptor[0]);
        return new DefaultOperationMethod(properties, descriptor);
    }

    final MathTransform completeTransform(MathTransformFactory factory) throws FactoryException {
        MathTransform tr = this.complete;
        if (tr == null) {
            tr = this.context.completeTransform(factory, this);
            if (CoordinateOperations.isDefaultInstance(factory)) {
                this.complete = tr;
            }
        }
        return tr;
    }

    final MathTransform passthrough(MathTransformFactory factory) throws FactoryException {
        MathTransform tr = this.passthrough;
        if (tr == null) {
            tr = factory.createPassThroughTransform(0, this.completeTransform(factory), 1);
            if (CoordinateOperations.isDefaultInstance(factory)) {
                this.passthrough = tr;
            }
        }
        return tr;
    }

    @Override
    public final int getSourceDimensions() {
        return this.dimension;
    }

    @Override
    public final int getTargetDimensions() {
        return this.dimension;
    }

    @Override
    public final ParameterValueGroup getParameterValues() {
        return this.context;
    }

    @Override
    protected final ContextualParameters getContextualParameters() {
        return this.context;
    }

    @Override
    protected final void tryConcatenate(TransformJoiner context) throws FactoryException {
        block12: {
            int n;
            ExtendedPrecisionMatrix linear;
            if (context.getTransform(-this.linearTransformPosition).map(MathTransforms::isLinear).orElse(true).booleanValue() && (linear = ExtendedPrecisionMatrix.castOrWrap(context.getMatrix(this.linearTransformPosition))) != null && (n = linear.getNumRow()) == linear.getNumCol()) {
                Number scale = null;
                for (int j = 0; j < n; ++j) {
                    for (int i = 0; i < n; ++i) {
                        Number e = linear.getElementOrNull(j, i);
                        if (e == null != (i == j)) {
                            if (e == null) continue;
                            if (i < n - 1) {
                                if (scale == null) {
                                    scale = e;
                                    continue;
                                }
                                if (scale.equals(e)) continue;
                            } else if (e.doubleValue() == 1.0) {
                                continue;
                            }
                        }
                        break block12;
                    }
                }
                if (scale != null) {
                    MatrixSIS angular = Matrices.create(n, n, ExtendedPrecisionMatrix.CREATE_IDENTITY);
                    for (int j : this.linearDimensions) {
                        angular.setNumber(j, j, scale);
                    }
                    MathTransform first = context.factory.createAffineTransform((Matrix)angular);
                    CoordinateSystemTransform other = this;
                    if (this.linearTransformPosition < 0) {
                        other = first;
                        first = this;
                    }
                    if (context.replace(this.linearTransformPosition, first = context.concatenate(first, other))) {
                        return;
                    }
                }
            }
        }
        super.tryConcatenate(context);
    }

    static final class Proxy
    implements Serializable {
        private static final long serialVersionUID = -2177879597869330855L;
        private final Class<? extends CoordinateSystemTransform> type;

        Proxy(Class<? extends CoordinateSystemTransform> type) {
            this.type = type;
        }

        private Object readResolve() throws ObjectStreamException {
            if (this.type == CartesianToSpherical.class) {
                return CartesianToSpherical.INSTANCE;
            }
            if (this.type == SphericalToCartesian.class) {
                return SphericalToCartesian.INSTANCE;
            }
            if (this.type == PolarToCartesian.class) {
                return PolarToCartesian.INSTANCE;
            }
            if (this.type == CartesianToPolar.class) {
                return CartesianToPolar.INSTANCE;
            }
            throw new InvalidClassException(this.type.getCanonicalName(), this.type.toString());
        }
    }
}

