/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.internal.shared.Identifiers;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.metadata.internal.shared.NameToIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.referencing.datum.DefaultEngineeringDatum;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.datum.DefaultParametricDatum;
import org.apache.sis.referencing.datum.DefaultTemporalDatum;
import org.apache.sis.referencing.datum.DefaultVerticalDatum;
import org.apache.sis.referencing.datum.DynamicReferenceFrame;
import org.apache.sis.referencing.internal.Legacy;
import org.apache.sis.referencing.internal.shared.NilReferencingObject;
import org.apache.sis.referencing.legacy.DefaultImageDatum;
import org.apache.sis.temporal.TemporalDate;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.util.InternationalString;

@XmlType(name="AbstractDatumType", propOrder={"anchorPoint", "realizationEpoch"})
@XmlRootElement(name="AbstractDatum")
@XmlSeeAlso(value={DefaultGeodeticDatum.class, DefaultVerticalDatum.class, DefaultTemporalDatum.class, DefaultParametricDatum.class, DefaultEngineeringDatum.class, DefaultImageDatum.class})
public class AbstractDatum
extends AbstractIdentifiedObject
implements Datum {
    private static final long serialVersionUID = 5380816794438838309L;
    public static final String ANCHOR_DEFINITION_KEY = "anchorDefinition";
    public static final String ANCHOR_EPOCH_KEY = "anchorEpoch";
    public static final String PUBLICATION_DATE_KEY = "publicationDate";
    public static final String CONVENTIONAL_RS_KEY = "conventionalRS";
    private InternationalString anchorDefinition;
    private Temporal anchorEpoch;
    private final Temporal publicationDate;
    private final IdentifiedObject conventionalRS;

    public AbstractDatum(Map<String, ?> properties) {
        super(properties);
        this.anchorDefinition = Types.toInternationalString(properties, (String)ANCHOR_DEFINITION_KEY);
        if (this.anchorDefinition == null) {
            this.anchorDefinition = Types.toInternationalString(properties, (String)"anchorPoint");
        }
        this.anchorEpoch = (Temporal)Containers.property(properties, (Object)ANCHOR_EPOCH_KEY, Temporal.class);
        if (this.anchorEpoch == null) {
            this.anchorEpoch = TemporalDate.toTemporal((Date)((Date)Containers.property(properties, (Object)"realizationEpoch", Date.class)));
        }
        this.publicationDate = (Temporal)Containers.property(properties, (Object)PUBLICATION_DATE_KEY, Temporal.class);
        this.conventionalRS = (IdentifiedObject)Containers.property(properties, (Object)CONVENTIONAL_RS_KEY, IdentifiedObject.class);
    }

    protected AbstractDatum(Datum datum) {
        super((IdentifiedObject)datum);
        Date date = datum.getRealizationEpoch();
        if (date != null) {
            this.anchorEpoch = date.toInstant();
        }
        this.anchorDefinition = datum.getAnchorPoint();
        if (datum instanceof AbstractDatum) {
            AbstractDatum cd = (AbstractDatum)datum;
            this.publicationDate = cd.getPublicationDate().orElse(null);
            this.conventionalRS = cd.getConventionalRS().orElse(null);
        } else {
            this.publicationDate = null;
            this.conventionalRS = null;
        }
    }

    public static AbstractDatum castOrCopy(Datum object) {
        if (object instanceof GeodeticDatum) {
            return DefaultGeodeticDatum.castOrCopy((GeodeticDatum)object);
        }
        if (object instanceof VerticalDatum) {
            return DefaultVerticalDatum.castOrCopy((VerticalDatum)object);
        }
        if (object instanceof TemporalDatum) {
            return DefaultTemporalDatum.castOrCopy((TemporalDatum)object);
        }
        if (object instanceof EngineeringDatum) {
            return DefaultEngineeringDatum.castOrCopy((EngineeringDatum)object);
        }
        if (object instanceof ImageDatum) {
            return DefaultImageDatum.castOrCopy((ImageDatum)object);
        }
        if (object == null || object instanceof AbstractDatum) {
            return (AbstractDatum)object;
        }
        return new AbstractDatum(object);
    }

    public Class<? extends Datum> getInterface() {
        return Datum.class;
    }

    public Optional<InternationalString> getAnchorDefinition() {
        return Optional.ofNullable(this.anchorDefinition);
    }

    @Deprecated(since="1.5")
    @XmlElement(name="anchorDefinition")
    public InternationalString getAnchorPoint() {
        return this.anchorDefinition;
    }

    public Optional<Temporal> getAnchorEpoch() {
        return Optional.ofNullable(this.anchorEpoch);
    }

    @Deprecated(since="1.5")
    @XmlSchemaType(name="date")
    @XmlElement(name="realizationEpoch")
    public Date getRealizationEpoch() {
        return this.getAnchorEpoch().map(Legacy::toDate).orElse(null);
    }

    @Deprecated(since="1.4")
    public Extent getDomainOfValidity() {
        return Legacy.getDomainOfValidity(this.getDomains());
    }

    @Deprecated(since="1.4")
    public InternationalString getScope() {
        return Legacy.getScope(this.getDomains());
    }

    Temporal getFrameReferenceEpoch() {
        return this instanceof DynamicReferenceFrame ? ((DynamicReferenceFrame)((Object)this)).getFrameReferenceEpoch() : null;
    }

    public Optional<Temporal> getPublicationDate() {
        return Optional.ofNullable(this.publicationDate);
    }

    public Optional<IdentifiedObject> getConventionalRS() {
        return Optional.ofNullable(this.conventionalRS);
    }

    @Override
    public boolean isHeuristicMatchForName(String name) {
        return NameToIdentifier.isHeuristicMatchForName((Identifier)super.getName(), super.getAlias(), (CharSequence)name, (NameToIdentifier.Simplifier)Simplifier.INSTANCE);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                AbstractDatum that = (AbstractDatum)object;
                return Objects.equals(this.anchorEpoch, that.anchorEpoch) && Objects.equals(this.anchorDefinition, that.anchorDefinition) && Objects.equals(this.publicationDate, that.publicationDate) && Objects.equals(this.conventionalRS, that.conventionalRS);
            }
            case BY_CONTRACT: {
                if (!(object instanceof AbstractDatum)) {
                    return this.getAnchorEpoch().isEmpty() && this.getAnchorDefinition().isEmpty() && this.getPublicationDate().isEmpty() && this.getConventionalRS().isEmpty();
                }
                AbstractDatum that = (AbstractDatum)object;
                return this.compareDynamicReferenceFrames(that, mode) && Utilities.deepEquals(this.getAnchorEpoch(), that.getAnchorEpoch(), (ComparisonMode)mode) && Utilities.deepEquals(this.getAnchorDefinition(), that.getAnchorDefinition(), (ComparisonMode)mode) && Utilities.deepEquals(this.getPublicationDate(), that.getPublicationDate(), (ComparisonMode)mode) && Utilities.deepEquals(this.getConventionalRS(), that.getConventionalRS(), (ComparisonMode)mode);
            }
        }
        Datum that = (Datum)object;
        if (!mode.isCompatibility() && !this.compareDynamicReferenceFrames(that, mode)) {
            return false;
        }
        Boolean match = Identifiers.hasCommonIdentifier(this.getIdentifiers(), (Iterable)that.getIdentifiers());
        if (match != null) {
            return match;
        }
        return this.isHeuristicMatchForName(that.getName().getCode()) || IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)that, this.getName().getCode());
    }

    private boolean compareDynamicReferenceFrames(Datum that, ComparisonMode mode) {
        Temporal frameReferenceEpoch = this.getFrameReferenceEpoch();
        if (frameReferenceEpoch != null) {
            return that instanceof DynamicReferenceFrame && Utilities.deepEquals((Object)frameReferenceEpoch, (Object)((DynamicReferenceFrame)that).getFrameReferenceEpoch(), (ComparisonMode)mode);
        }
        return !(that instanceof DynamicReferenceFrame);
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash(this.anchorDefinition, this.anchorEpoch, this.publicationDate, this.conventionalRS);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        Citation authority = formatter.getNameAuthority();
        Object name = IdentifiedObjects.getName(this, authority);
        if (name == null) {
            name = IdentifiedObjects.getName(this, null);
            if (name == null) {
                name = Vocabulary.forLocale((Locale)formatter.getLocale()).getString((short)208);
            } else if ("ESRI".equalsIgnoreCase(Citations.toCodeSpace((Citation)authority)) && !((String)name).startsWith("D_")) {
                name = "D_" + (String)name;
            }
        }
        formatter.append((String)name, ElementKind.DATUM);
        if (formatter.getEnclosingElement(1) instanceof DefaultDatumEnsemble) {
            return "Member";
        }
        return null;
    }

    AbstractDatum() {
        super((IdentifiedObject)NilReferencingObject.INSTANCE);
        this.publicationDate = null;
        this.conventionalRS = null;
    }

    private void setAnchorPoint(InternationalString value) {
        if (this.anchorDefinition == null) {
            this.anchorDefinition = value;
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractDatum.class, (String)"setAnchorPoint", (String)ANCHOR_DEFINITION_KEY);
        }
    }

    private void setRealizationEpoch(Date value) {
        if (this.anchorEpoch == null) {
            this.anchorEpoch = TemporalDate.toTemporal((Date)value);
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractDatum.class, (String)"setRealizationEpoch", (String)"realizationEpoch");
        }
    }

    static class Simplifier
    extends NameToIdentifier.Simplifier {
        static final Simplifier INSTANCE = new Simplifier();

        Simplifier() {
        }

        protected CharSequence apply(CharSequence name) {
            if (CharSequences.startsWith((CharSequence)(name = super.apply(name)), (CharSequence)"D_", (boolean)false)) {
                name = name.subSequence("D_".length(), name.length());
            }
            return name;
        }
    }
}

