/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bgservlets.impl.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.bgservlets.JobConsole;
import org.apache.sling.bgservlets.JobStatus;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

@Component
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"sling/bg/job"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class JobInfoServlet
extends SlingSafeMethodsServlet {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_EXT = "txt";
    private static final Map<String, Renderer> renderers = new HashMap<String, Renderer>();
    @Reference
    private JobConsole jobConsole;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            Node n = (Node)request.getResource().adaptTo(Node.class);
            JobStatus j = this.jobConsole.getJobStatus(n.getSession(), n.getPath());
            String streamPath = j.getStreamPath();
            String fullStreamPath = request.getContextPath() + streamPath;
            String ext = request.getRequestPathInfo().getExtension();
            Renderer r = renderers.get(ext);
            if (r == null) {
                r = renderers.get(DEFAULT_EXT);
            }
            if (r == null) {
                response.sendError(400, "No JobRenderer available for extension '" + ext + "'");
            }
            response.setContentType(request.getResponseContentType());
            response.setCharacterEncoding(DEFAULT_ENCODING);
            r.render(response.getWriter(), fullStreamPath, streamPath);
        }
        catch (RepositoryException re) {
            throw new ServletException("RepositoryException in doGet", (Throwable)re);
        }
    }

    static {
        renderers.put(DEFAULT_EXT, new TextRenderer());
        renderers.put("html", new HtmlRenderer());
        renderers.put("json", new JsonRenderer());
    }

    protected void bindJobConsole(JobConsole jobConsole) {
        this.jobConsole = jobConsole;
    }

    protected void unbindJobConsole(JobConsole jobConsole) {
        if (this.jobConsole == jobConsole) {
            this.jobConsole = null;
        }
    }

    private static class JsonRenderer
    implements Renderer {
        private JsonRenderer() {
        }

        @Override
        public void render(PrintWriter pw, String streamPath, String streamResource) throws IOException {
            JSONWriter w = new JSONWriter((Writer)pw);
            try {
                w.object();
                w.key("info");
                w.value((Object)"Background job information");
                w.key("jobStreamPath");
                w.value((Object)streamPath);
                w.endObject();
            }
            catch (JSONException e) {
                throw (IOException)new IOException("JSONException in " + this.getClass().getSimpleName()).initCause(e);
            }
        }
    }

    private static class HtmlRenderer
    implements Renderer {
        private HtmlRenderer() {
        }

        @Override
        public void render(PrintWriter pw, String streamPath, String streamResource) {
            pw.println("<html><head><title>Background job</title>");
            pw.println("<link rel='stream' href='" + streamPath + "'/>");
            pw.println("</head><body>");
            pw.println("<h1>Background job information</h1>");
            pw.println("Job output available at");
            pw.println("<a href='" + streamPath + "'>" + streamResource + "</a>");
            pw.println("</body>");
        }
    }

    private static class TextRenderer
    implements Renderer {
        private TextRenderer() {
        }

        @Override
        public void render(PrintWriter pw, String streamPath, String streamResource) {
            pw.println("Background execution: job output available at ");
            pw.println(streamPath);
        }
    }

    static interface Renderer {
        public void render(PrintWriter var1, String var2, String var3) throws IOException;
    }
}

