/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.diff.impl;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Configurations;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.diff.impl.AbstractFeatureElementComparator;

public final class ConfigurationsComparator
extends AbstractFeatureElementComparator {
    private static final String SERVICE_PID_KEY = "service.pid";
    private static final String SERVICE_FACTORY_PID_KEY = "service.factoryPid";

    public ConfigurationsComparator() {
        super("configurations");
    }

    @Override
    public void computeDiff(Feature previous, Feature current, Feature target) {
        this.computeDiff(previous.getConfigurations(), current.getConfigurations(), target);
    }

    protected void computeDiff(Configurations previouses, Configurations currents, Feature target) {
        for (Configuration previousConfiguration : previouses) {
            Configuration currentConfiguration = currents.getConfiguration(previousConfiguration.getPid());
            if (currentConfiguration == null) {
                target.getPrototype().getConfigurationRemovals().add(previousConfiguration.getPid());
                continue;
            }
            this.computeDiff(previousConfiguration, currentConfiguration, target);
        }
        for (Configuration currentConfiguration : currents) {
            Configuration previousConfiguration = previouses.getConfiguration(currentConfiguration.getPid());
            if (previousConfiguration != null) continue;
            target.getConfigurations().add((Object)currentConfiguration);
        }
    }

    protected void computeDiff(Configuration previous, Configuration current, Feature target) {
        Dictionary previousProperties = previous.getProperties();
        Dictionary currentProperties = current.getProperties();
        Configuration targetConfiguration = new Configuration(previous.getPid());
        Dictionary targetProperties = targetConfiguration.getProperties();
        Enumeration previousKeys = previousProperties.keys();
        while (previousKeys.hasMoreElements()) {
            Object currentValue;
            Object previousValue;
            String previousKey = (String)previousKeys.nextElement();
            if (ConfigurationsComparator.isReservedKey(previousKey) || !ConfigurationsComparator.hasKey(previousKey, currentProperties.keys()) || ConfigurationsComparator.areEquals(previousValue = previousProperties.get(previousKey), currentValue = currentProperties.get(previousKey))) continue;
            targetProperties.put(previousKey, currentValue);
        }
        Enumeration currentKeys = currentProperties.keys();
        while (currentKeys.hasMoreElements()) {
            String currentKey = (String)currentKeys.nextElement();
            if (ConfigurationsComparator.isReservedKey(currentKey)) continue;
            Object previousValue = previousProperties.get(currentKey);
            Object currentValue = currentProperties.get(currentKey);
            if (previousValue != null || currentValue == null) continue;
            targetProperties.put(currentKey, currentValue);
        }
        if (!targetProperties.isEmpty()) {
            target.getConfigurations().add((Object)targetConfiguration);
        }
    }

    private static boolean isReservedKey(String key) {
        return SERVICE_PID_KEY.equals(key) || SERVICE_FACTORY_PID_KEY.equals(key);
    }

    private static boolean areEquals(Object lhs, Object rhs) {
        Class<?> testClass;
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null ^ rhs == null) {
            return false;
        }
        Class<?> lhsClass = lhs.getClass();
        Class<?> rhsClass = rhs.getClass();
        if (lhsClass.isInstance(rhs)) {
            testClass = lhsClass;
            if (!rhsClass.isInstance(lhs)) {
                testClass = rhsClass;
            }
        } else if (rhsClass.isInstance(lhs)) {
            testClass = rhsClass;
            if (!lhsClass.isInstance(rhs)) {
                testClass = lhsClass;
            }
        } else {
            return false;
        }
        if (testClass.isArray()) {
            return Objects.deepEquals(lhs, rhs);
        }
        if (Collection.class.isAssignableFrom(testClass)) {
            return ConfigurationsComparator.areEquals((Collection)lhs, (Collection)rhs);
        }
        if (Map.class.isAssignableFrom(testClass)) {
            return ConfigurationsComparator.areEquals((Map)lhs, (Map)rhs);
        }
        return Objects.equals(lhs, rhs);
    }

    private static boolean areEquals(Collection<?> lhs, Collection<?> rhs) {
        if (lhs.size() != rhs.size()) {
            return false;
        }
        return Objects.deepEquals(lhs.toArray(), rhs.toArray());
    }

    private static boolean areEquals(Map<?, ?> lhs, Map<?, ?> rhs) {
        for (Map.Entry<?, ?> previousEntry : lhs.entrySet()) {
            Object currentValue;
            Object previousKey = previousEntry.getKey();
            if (!rhs.containsKey(previousKey)) {
                return false;
            }
            Object previousValue = previousEntry.getValue();
            if (ConfigurationsComparator.areEquals(previousValue, currentValue = rhs.get(previousKey))) continue;
            return false;
        }
        for (Map.Entry<Object, Object> currentKey : rhs.keySet()) {
            if (lhs.containsKey(currentKey)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasKey(String key, Enumeration<String> keys) {
        while (keys.hasMoreElements()) {
            String current = keys.nextElement();
            if (!key.equals(current)) continue;
            return true;
        }
        return false;
    }
}

