/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.launcher.impl;

import java.io.File;
import java.io.PrintWriter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.launcher.impl.Bootstrap;
import org.apache.sling.feature.launcher.impl.LauncherConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    public static final String OPT_OSGI_FRAMEWORK_ARTIFACT = "fa";
    public static final String OPT_FELIX_FRAMEWORK_VERSION = "fv";
    public static final String OPT_EXTENSION_CONFIGURATION = "ec";
    public static final String OPT_HOME_DIR = "p";
    public static final String OPT_CACHE_DIR = "c";
    public static final String OPT_VERBOSE = "v";
    public static final String OPT_VARIABLE_VALUES = "V";
    public static final String OPT_FRAMEWORK_PROPERTIES = "D";
    public static final String OPT_FEATURE_FILES = "f";
    public static final String OPT_REPOSITORY_URLS = "u";
    public static final String OPT_CONFIG_CLASH = "CC";
    public static final String OPT_ARTICACT_CLASH = "C";
    public static final String OPT_PRINT_CONTAINER_ENV_HELP = "cenv";
    public static final String OPT_LAUNCH_FEATURE_ID = "i";
    public static final String OPT_CACHE_ONLY = "CO";
    private static Logger LOGGER;
    private static Options options;
    private static final List<String> logLevels;

    private static Logger LOG() {
        if (LOGGER == null) {
            LOGGER = LoggerFactory.getLogger((String)"launcher");
        }
        return LOGGER;
    }

    static String[] splitKeyVal(String keyVal) {
        int pos = keyVal.indexOf(61);
        if (pos == -1) {
            return new String[]{keyVal, "true"};
        }
        return new String[]{keyVal.substring(0, pos), keyVal.substring(pos + 1)};
    }

    static Map.Entry<String, Map<String, String>> splitMap2(String val) {
        String[] split1 = val.split(":");
        if (split1.length < 2) {
            return new AbstractMap.SimpleEntry<String, Map<String, String>>(split1[0], Collections.emptyMap());
        }
        Map<String, String> m = Main.splitMap(split1[1]);
        return new AbstractMap.SimpleEntry<String, Map<String, String>>(split1[0], m);
    }

    private static Map<String, String> splitMap(String value) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (String kv : value.split(",")) {
            String[] keyval = Main.splitKeyVal(kv);
            m.put(keyval[0], keyval[1]);
        }
        return m;
    }

    private static Optional<String> extractValueFromOption(CommandLine cl, String opt) {
        return Main.extractValueFromOption(cl, opt, null);
    }

    private static Optional<String> extractValueFromOption(CommandLine cl, String opt, String defaultVaue) {
        return Optional.ofNullable(cl.getOptionValue(opt, defaultVaue));
    }

    private static Optional<List<String>> extractValuesFromOption(CommandLine cl, String opt) {
        String[] values = cl.getOptionValues(opt);
        if (Objects.isNull(values)) {
            return Optional.empty();
        }
        return Optional.of(Stream.of(values).collect(Collectors.toList()));
    }

    protected static void parseArgs(LauncherConfig config, String[] args) {
        Option artifactClashOverride = Option.builder((String)OPT_ARTICACT_CLASH).longOpt("artifact-clash").desc("Set artifact clash override").optionalArg(true).numberOfArgs(-2).build();
        Option configClashOverride = Option.builder((String)OPT_CONFIG_CLASH).longOpt("config-clash").desc("Set config clash override").optionalArg(true).numberOfArgs(-2).build();
        Option repoOption = Option.builder((String)OPT_REPOSITORY_URLS).longOpt("repository-urls").desc("Set repository urls").optionalArg(true).valueSeparator(',').numberOfArgs(-2).build();
        Option featureOption = Option.builder((String)OPT_FEATURE_FILES).longOpt("feature-files").desc("Set feature files").optionalArg(true).valueSeparator(',').numberOfArgs(-2).build();
        Option featureIdOption = Option.builder((String)OPT_LAUNCH_FEATURE_ID).longOpt("launch-feature-id").desc("Set the id for the launch feature").optionalArg(true).numberOfArgs(1).build();
        Option fwkProperties = Option.builder((String)OPT_FRAMEWORK_PROPERTIES).longOpt("framework-property").desc("Set framework property, format: -D key1=val1 -D key2=val2").hasArg().optionalArg(true).build();
        Option varValue = Option.builder((String)OPT_VARIABLE_VALUES).longOpt("variable-value").desc("Set variable value, format: -V key1=val1 -V key2=val2").optionalArg(true).numberOfArgs(-2).build();
        Option debugOption = Option.builder((String)OPT_VERBOSE).longOpt("verbose").desc("Verbose").optionalArg(true).numberOfArgs(1).build();
        Option cacheOnlyOption = Option.builder((String)OPT_CACHE_ONLY).longOpt("cacheOnly").desc("Cache only the required dependencies. Don't start the framework.").optionalArg(true).build();
        Option cacheOption = Option.builder((String)OPT_CACHE_DIR).longOpt("cache_dir").desc("Set cache dir").optionalArg(true).numberOfArgs(1).build();
        Option homeOption = Option.builder((String)OPT_HOME_DIR).longOpt("home_dir").desc("Set home dir").optionalArg(true).numberOfArgs(1).build();
        Option extensionConfiguration = Option.builder((String)OPT_EXTENSION_CONFIGURATION).longOpt("extension_configuration").desc("Provide extension configuration, format: extensionName:key1=val1,key2=val2").optionalArg(true).numberOfArgs(-2).build();
        Option frameworkVersionOption = Option.builder((String)OPT_FELIX_FRAMEWORK_VERSION).longOpt("felix-framework-version").desc("Set Apache Felix framework version (default ".concat("7.0.3") + ")").optionalArg(true).numberOfArgs(1).build();
        Option frameworkArtifactOption = Option.builder((String)OPT_OSGI_FRAMEWORK_ARTIFACT).longOpt("osgi-framework-artifact").desc("Set OSGi framework artifact (overrides Apache Felix framework version)").optionalArg(true).numberOfArgs(1).build();
        Option printInsideContainerHelp = Option.builder((String)OPT_PRINT_CONTAINER_ENV_HELP).desc("print additional help information for container env vars.").optionalArg(true).build();
        options = new Options().addOption(artifactClashOverride).addOption(configClashOverride).addOption(repoOption).addOption(featureOption).addOption(featureIdOption).addOption(fwkProperties).addOption(varValue).addOption(debugOption).addOption(cacheOnlyOption).addOption(cacheOption).addOption(homeOption).addOption(extensionConfiguration).addOption(frameworkVersionOption).addOption(frameworkArtifactOption).addOption(printInsideContainerHelp);
        DefaultParser clp = new DefaultParser();
        try {
            CommandLine cl = clp.parse(options, args);
            Main.extractValuesFromOption(cl, OPT_REPOSITORY_URLS).ifPresent(values -> config.setRepositoryUrls((String[])values.stream().toArray(String[]::new)));
            Main.extractValuesFromOption(cl, OPT_ARTICACT_CLASH).ifPresent(values -> values.forEach(v -> config.getArtifactClashOverrides().add(ArtifactId.parse((String)v))));
            Main.extractValuesFromOption(cl, OPT_CONFIG_CLASH).orElseGet(ArrayList::new).forEach(value -> {
                String[] keyVal = Main.split(value);
                config.getConfigClashOverrides().put(keyVal[0], keyVal[1]);
            });
            Main.extractValuesFromOption(cl, OPT_FRAMEWORK_PROPERTIES).orElseGet(ArrayList::new).forEach(value -> {
                String[] keyVal = Main.split(value);
                config.getInstallation().getFrameworkProperties().put(keyVal[0], keyVal[1]);
            });
            Main.extractValuesFromOption(cl, OPT_VARIABLE_VALUES).orElseGet(ArrayList::new).forEach(value -> {
                String[] keyVal = Main.split(value);
                config.getVariables().put(keyVal[0], keyVal[1]);
            });
            if (cl.hasOption(OPT_VERBOSE)) {
                Main.extractValueFromOption(cl, OPT_VERBOSE, "debug").ifPresent(value -> {
                    if (Main.isLoglevel(value)) {
                        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", value);
                    }
                });
            }
            if (cl.hasOption(OPT_CACHE_ONLY)) {
                config.setCacheOnly(true);
            }
            Main.extractValuesFromOption(cl, OPT_FEATURE_FILES).orElseGet(ArrayList::new).forEach(xva$0 -> config.addFeatureFiles((String)xva$0));
            Main.extractValueFromOption(cl, OPT_LAUNCH_FEATURE_ID).ifPresent(config::setLaunchFeatureId);
            Main.extractValueFromOption(cl, OPT_CACHE_DIR).map(File::new).ifPresent(arg_0 -> ((LauncherConfig)config).setCacheDirectory(arg_0));
            Main.extractValueFromOption(cl, OPT_HOME_DIR).map(File::new).ifPresent(config::setHomeDirectory);
            Main.extractValuesFromOption(cl, OPT_EXTENSION_CONFIGURATION).ifPresent(values -> values.forEach(v -> {
                Map.Entry<String, Map<String, String>> xc = Main.splitMap2(v);
                Map<String, Map<String, String>> ec = config.getExtensionConfiguration();
                Map<String, String> c = ec.get(xc.getKey());
                if (c == null) {
                    c = new HashMap<String, String>();
                    ec.put(xc.getKey(), c);
                }
                c.putAll(xc.getValue());
            }));
            Main.extractValueFromOption(cl, OPT_FELIX_FRAMEWORK_VERSION).ifPresent(config::setFrameworkVersion);
            Main.extractValueFromOption(cl, OPT_OSGI_FRAMEWORK_ARTIFACT).ifPresent(config::setFrameworkArtifact);
        }
        catch (ParseException pe) {
            Main.LOG().error("Unable to parse command line: {}", (Object)pe.getMessage(), (Object)pe);
            Main.printHelp();
            System.exit(1);
        }
    }

    private static boolean isLoglevel(String value) {
        return logLevels.contains(value);
    }

    static void printHelp() {
        if (options == null) {
            return;
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("launcher", options);
        if (options.getOption(OPT_PRINT_CONTAINER_ENV_HELP) != null) {
            try (PrintWriter writer = new PrintWriter(System.out);){
                writer.println("");
                writer.println("If you are running sling-feature-launcher as an container please use env vars.");
                writer.println("");
                writer.println(" cli-arg  -  container ENV variable");
                writer.println("-------------------------------------");
                writer.println(" -C       -  ARTIFACT_CLASH");
                writer.println(" -CC      -  CONFIG_CLASH");
                writer.println(" -c       -  CACHE_DIR");
                writer.println(" -D       -  FRAMEWORK_PROPERTIES format: `key1=val1` for more `key1=val1 -D key2=val2`");
                writer.println(" -f       -  FEATURE_FILES");
                writer.println(" -p       -  HOME_DIR");
                writer.println(" -u       -  REPOSITORY_URLS");
                writer.println(" -V       -  VARIABLE_VALUES format: `variable1=value1` for more `variable1=val1 -V variable2=val2`");
                writer.println(" -ec      -  EXTENSION_CONFIGURATION");
                writer.println(" -fv      -  FELIX_FRAMEWORK_VERSION");
                writer.println(" -fa      -  OSGI_FRAMEWORK_ARTIFACT");
                writer.println(" -v       -  VERBOSE {trace, debug, info, warn, error, off}");
                writer.println("");
                writer.println("Java options could be set using the env var 'JAVA_OPTS'");
                writer.flush();
            }
        }
    }

    private static String[] split(String val) {
        int pos = val.indexOf(61);
        if (pos == -1) {
            return new String[]{val, "true"};
        }
        return new String[]{val.substring(0, pos), val.substring(pos + 1)};
    }

    public static void main(String[] args) {
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "info");
        System.setProperty("org.slf4j.simpleLogger.showThreadName", "false");
        System.setProperty("org.slf4j.simpleLogger.levelInBrackets", "true");
        System.setProperty("org.slf4j.simpleLogger.showLogName", "false");
        LauncherConfig launcherConfig = new LauncherConfig();
        Main.parseArgs(launcherConfig, args);
        Bootstrap bootstrap = new Bootstrap(launcherConfig, Main.LOG());
        bootstrap.run();
    }

    static {
        logLevels = Arrays.asList("trace", "debug", "info", "warn", "error", "off");
    }
}

