/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.modelconverter;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.feature.modelconverter.ProvisioningToFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="pm2fm", description={"Apache Sling Provisioning Model to Sling Feature Model converter"}, footer={"Copyright(c) 2019-2020 The Apache Software Foundation."})
public class Main
implements Runnable {
    public static final String PACKAGING_FEATURE = "slingosgifeature";
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Display the usage message"})
    private boolean helpRequested;
    @CommandLine.Option(names={"-i", "--provisining-input-directory"}, description={"The input directory where the Provisioning File are"}, required=true)
    private File provisioningModelsInputDirectory;
    @CommandLine.Option(names={"-o", "--features-output-directory"}, description={"The output directory where the Feature File will be generated in"}, required=true)
    private File featureModelsOutputDirectory;
    @CommandLine.Option(names={"-g", "--group-id"}, description={"Overwriting the Group Id of the Model ID"})
    private String groupId;
    @CommandLine.Option(names={"-v", "--version"}, description={"Overwriting the Version of the Model ID"})
    private String version;
    @CommandLine.Option(names={"-V", "--useProvidedVersion"}, description={"If flagged then the provided version will override any given version from Provisioning Model"})
    private boolean useProvidedVersion;
    @CommandLine.Option(names={"-n", "--name"}, description={"Sets a General Name for all converted Models. This also means that the name is placed in the classifier"})
    private String name;
    @CommandLine.Option(names={"-d", "--dropVariable"}, description={"Variable (by name) in a Feature Model to be excluded (repeat for more)"})
    private List<String> dropVariables;
    @CommandLine.Option(names={"-a", "--addFrameworkProperty"}, description={"Adds Framework Property to Feature Models. Format: <Model Name>:<Property Name>=<value> (repeat for more)"})
    private List<String> addFrameworkProperties;
    @CommandLine.Option(names={"-D", "--noProvisioningModelName"}, description={"If flagged then the Provisioning Model Name is not added"})
    private boolean noProvisioningModelName;
    @CommandLine.Option(names={"-e", "--excludeBundle"}, description={"Bundle and/or Bundle Configuration to be excluded (repeat for more)"})
    private List<String> excludeBundles;
    @CommandLine.Option(names={"-r", "--runMode"}, description={"Runmode to add to this build (all no-runmodes are included by default, repeat for more)"})
    private List<String> runModes;
    private Pattern pattern = Pattern.compile("^(.*?):(.*?)=(.*?)$");

    @Override
    public void run() {
        try {
            if (!this.provisioningModelsInputDirectory.isDirectory()) {
                throw new IllegalArgumentException("Input Folder is not a directory");
            }
            if (!this.provisioningModelsInputDirectory.canRead()) {
                throw new IllegalArgumentException("Input Folder is not readable");
            }
            if (!this.featureModelsOutputDirectory.exists()) {
                File parent = this.featureModelsOutputDirectory.getParentFile();
                if (parent == null || !parent.exists()) {
                    throw new IllegalArgumentException("Parent Folder (" + parent + ") of output folder (" + this.featureModelsOutputDirectory + ") does not exist");
                }
                this.featureModelsOutputDirectory.mkdir();
            }
            if (!this.featureModelsOutputDirectory.isDirectory()) {
                throw new IllegalArgumentException("Output Folder is not a directory");
            }
            if (!this.featureModelsOutputDirectory.canWrite()) {
                throw new IllegalArgumentException("Output Folder is not writable");
            }
            List<File> provisioningFiles = Arrays.asList(this.provisioningModelsInputDirectory.listFiles());
            HashMap<String, Object> options = new HashMap<String, Object>();
            if (this.groupId != null && !this.groupId.isEmpty()) {
                options.put("groupId", this.groupId);
            }
            if (this.version != null && !this.version.isEmpty()) {
                options.put("version", this.version);
            }
            if (this.name != null && !this.name.isEmpty()) {
                options.put("name", this.name);
            }
            LOGGER.info("Use Provided Version Flag: '{}'", (Object)this.useProvidedVersion);
            options.put("useProvidedVersion", this.useProvidedVersion);
            options.put("noProvisioningModelName", this.noProvisioningModelName);
            options.put("dropVariables", this.dropVariables);
            HashMap<String, HashMap<String, String>> frameworkPropertiesMap = new HashMap<String, HashMap<String, String>>();
            for (String value : this.addFrameworkProperties) {
                LOGGER.info("Check Add Framework Properties Line: '{}'", (Object)value);
                Matcher matcher = this.pattern.matcher(value);
                LOGGER.info("Pattern Group Matches: '{}', Count: '{}'", (Object)matcher.matches(), (Object)matcher.groupCount());
                if (!matcher.matches() || matcher.groupCount() != 3) continue;
                String modelName = matcher.group(1);
                String propName = matcher.group(2);
                String propValue = matcher.group(3);
                LOGGER.info("Model Name: '{}', Prop Name: '{}', Value: '{}'", new Object[]{modelName, propName, propValue});
                HashMap<String, String> modelMap = (HashMap<String, String>)frameworkPropertiesMap.get(modelName);
                if (modelMap == null) {
                    modelMap = new HashMap<String, String>();
                    frameworkPropertiesMap.put(modelName, modelMap);
                }
                modelMap.put(propName, propValue);
            }
            options.put("addFrameworkProperties", frameworkPropertiesMap);
            options.put("excludeBundles", this.excludeBundles);
            LOGGER.info("Excluded Bundles: '{}'", this.excludeBundles);
            options.put("runModes", this.runModes == null ? new ArrayList() : this.runModes);
            LOGGER.info("Runmodes: '{}'", this.runModes);
            for (File file : provisioningFiles) {
                LOGGER.info("Handle File: '{}'", (Object)file.getAbsolutePath());
                ProvisioningToFeature.convert(file, this.featureModelsOutputDirectory, options);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Failed to Convert", t);
        }
    }

    public static void main(String[] args) {
        CommandLine.run((Runnable)new Main(), (String[])args);
    }
}

