/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.journal.Journal;
import org.apache.jackrabbit.core.journal.JournalFactory;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;

public class ClusterConfig
implements JournalFactory {
    private final String id;
    private final long syncDelay;
    private final long stopDelay;
    private final JournalFactory jf;

    public ClusterConfig(String id, long syncDelay, JournalFactory jf) {
        this(id, syncDelay, -1L, jf);
    }

    public ClusterConfig(String id, long syncDelay, long stopDelay, JournalFactory jf) {
        this.id = id;
        this.syncDelay = syncDelay;
        this.stopDelay = stopDelay < 0L ? syncDelay * 10L : stopDelay;
        this.jf = jf;
    }

    public String getId() {
        return this.id;
    }

    public long getSyncDelay() {
        return this.syncDelay;
    }

    public long getStopDelay() {
        return this.stopDelay;
    }

    @Override
    public Journal getJournal(NamespaceResolver resolver) throws RepositoryException {
        return this.jf.getJournal(resolver);
    }
}

