/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.nosql.mongodb.resourceprovider.impl;

import com.mongodb.DuplicateKeyException;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.nosql.generic.adapter.AbstractNoSqlAdapter;
import org.apache.sling.nosql.generic.adapter.MultiValueMode;
import org.apache.sling.nosql.generic.adapter.NoSqlData;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoDBNoSqlAdapter
extends AbstractNoSqlAdapter {
    private static final String PN_PATH = "_id";
    private static final String PN_PARENT_PATH = "parentPath";
    private static final String PN_DATA = "data";
    private final MongoCollection<Document> collection;
    private static final Logger log = LoggerFactory.getLogger(MongoDBNoSqlAdapter.class);

    public MongoDBNoSqlAdapter(MongoClient mongoClient, String database, String collection) {
        MongoDatabase db = mongoClient.getDatabase(database);
        this.collection = db.getCollection(collection);
    }

    public NoSqlData get(String path) {
        Document envelope = (Document)this.collection.find(Filters.eq((String)PN_PATH, (Object)path)).first();
        if (envelope == null) {
            return null;
        }
        return new NoSqlData(path, (Map)envelope.get((Object)PN_DATA, Document.class), MultiValueMode.LISTS);
    }

    public Iterator<NoSqlData> getChildren(String parentPath) {
        ArrayList<NoSqlData> children = new ArrayList<NoSqlData>();
        FindIterable result = this.collection.find(Filters.eq((String)PN_PARENT_PATH, (Object)parentPath));
        try (MongoCursor envelopes = result.iterator();){
            while (envelopes.hasNext()) {
                Document envelope = (Document)envelopes.next();
                String path = (String)envelope.get((Object)PN_PATH, String.class);
                Document data = (Document)envelope.get((Object)PN_DATA, Document.class);
                children.add(new NoSqlData(path, (Map)data, MultiValueMode.LISTS));
            }
        }
        return children.iterator();
    }

    public boolean store(NoSqlData data) {
        UpdateResult result;
        Document envelope = new Document();
        envelope.put(PN_PATH, (Object)data.getPath());
        envelope.put(PN_DATA, (Object)new Document(data.getProperties(MultiValueMode.LISTS)));
        String parentPath = ResourceUtil.getParent((String)data.getPath());
        if (parentPath != null) {
            envelope.put(PN_PARENT_PATH, (Object)parentPath);
        }
        return (result = this.collection.replaceOne(Filters.eq((String)PN_PATH, (Object)data.getPath()), (Object)envelope, new UpdateOptions().upsert(true))).getMatchedCount() == 0L;
    }

    public boolean deleteRecursive(String path) {
        Pattern descendantsAndSelf = Pattern.compile("^" + Pattern.quote(path) + "(/.+)?$");
        DeleteResult result = this.collection.deleteMany(Filters.regex((String)PN_PATH, (Pattern)descendantsAndSelf));
        return result.getDeletedCount() > 0L;
    }

    public void checkConnection() throws LoginException {
        try {
            this.collection.find(Filters.eq((String)PN_PATH, (Object)"/")).first();
        }
        catch (MongoException e) {
            throw new LoginException((Throwable)e);
        }
    }

    public void createIndexDefinitions() {
        try {
            Document parenPathtIndex = new Document(PN_PARENT_PATH, (Object)1);
            this.collection.createIndex((Bson)parenPathtIndex);
        }
        catch (DuplicateKeyException ex) {
        }
        catch (Throwable ex) {
            log.error("Unable to create index on parentPath: " + ex.getMessage(), ex);
        }
        try {
            Document pathIndex = new Document(PN_PATH, (Object)1);
            IndexOptions idxOptions = new IndexOptions();
            idxOptions.unique(true);
            this.collection.createIndex((Bson)pathIndex, idxOptions);
        }
        catch (DuplicateKeyException ex) {
        }
        catch (Throwable ex) {
            log.error("Unable to create unique index on _id: " + ex.getMessage(), ex);
        }
    }
}

