/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.configuration;

import java.util.TreeSet;
import org.owasp.esapi.configuration.AbstractPrioritizedPropertyLoader;
import org.owasp.esapi.configuration.EsapiPropertyLoader;
import org.owasp.esapi.configuration.EsapiPropertyLoaderFactory;
import org.owasp.esapi.configuration.consts.EsapiConfiguration;
import org.owasp.esapi.errors.ConfigurationException;

public class EsapiPropertyManager
implements EsapiPropertyLoader {
    protected TreeSet<AbstractPrioritizedPropertyLoader> loaders;

    public EsapiPropertyManager() {
        this.initLoaders();
    }

    @Override
    public int getIntProp(String propertyName) throws ConfigurationException {
        for (AbstractPrioritizedPropertyLoader loader : this.loaders) {
            try {
                return loader.getIntProp(propertyName);
            }
            catch (ConfigurationException e) {
                System.err.println("Property not found in " + loader.name());
            }
        }
        throw new ConfigurationException("Could not find property " + propertyName + " in configuration");
    }

    @Override
    public byte[] getByteArrayProp(String propertyName) throws ConfigurationException {
        for (AbstractPrioritizedPropertyLoader loader : this.loaders) {
            try {
                return loader.getByteArrayProp(propertyName);
            }
            catch (ConfigurationException e) {
                System.err.println("Property not found in " + loader.name());
            }
        }
        throw new ConfigurationException("Could not find property " + propertyName + " in configuration");
    }

    @Override
    public Boolean getBooleanProp(String propertyName) throws ConfigurationException {
        for (AbstractPrioritizedPropertyLoader loader : this.loaders) {
            try {
                return loader.getBooleanProp(propertyName);
            }
            catch (ConfigurationException e) {
                System.err.println("Property not found in " + loader.name());
            }
        }
        throw new ConfigurationException("Could not find property " + propertyName + " in configuration");
    }

    @Override
    public String getStringProp(String propertyName) throws ConfigurationException {
        for (AbstractPrioritizedPropertyLoader loader : this.loaders) {
            try {
                return loader.getStringProp(propertyName);
            }
            catch (ConfigurationException e) {
                System.err.println("Property : " + propertyName + " not found in " + loader.name());
            }
        }
        throw new ConfigurationException("Could not find property " + propertyName + " in configuration");
    }

    private void initLoaders() {
        this.loaders = new TreeSet();
        try {
            this.loaders.add(EsapiPropertyLoaderFactory.createPropertyLoader(EsapiConfiguration.OPSTEAM_ESAPI_CFG));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        try {
            this.loaders.add(EsapiPropertyLoaderFactory.createPropertyLoader(EsapiConfiguration.DEVTEAM_ESAPI_CFG));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

