/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.java.compiler.impl.operator;

import org.apache.sling.scripting.sightly.compiler.expression.NodeVisitor;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator;
import org.apache.sling.scripting.sightly.java.compiler.impl.ExpressionTranslator;
import org.apache.sling.scripting.sightly.java.compiler.impl.JavaSource;
import org.apache.sling.scripting.sightly.java.compiler.impl.Type;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.BinaryOpGen;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.TypedNode;

public class NumericOpGen
implements BinaryOpGen {
    private static final String OBJECT_NAME = BinaryOperator.class.getName();
    private static final String METHOD_NAME = "eval";
    private final String javaOperator;
    private final BinaryOperator binaryOperator;

    public NumericOpGen(String javaOperator, BinaryOperator binaryOperator) {
        this.javaOperator = javaOperator;
        this.binaryOperator = binaryOperator;
    }

    @Override
    public Type returnType(Type leftType, Type rightType) {
        return this.commonType(leftType, rightType);
    }

    @Override
    public void generate(JavaSource source, ExpressionTranslator visitor, TypedNode left, TypedNode right) {
        Type commonType = this.commonType(left.getType(), right.getType());
        source.objectModel().startCall("toNumber", true).startMethodCall(OBJECT_NAME + "." + this.binaryOperator.name(), METHOD_NAME);
        left.getNode().accept((NodeVisitor)visitor);
        source.separateArgument();
        right.getNode().accept((NodeVisitor)visitor);
        source.endCall().endCall().startCall(commonType.getNativeClass() + "Value", true).endCall();
    }

    protected Type commonType(Type leftType, Type rightType) {
        if (leftType == rightType && leftType == Type.LONG) {
            return Type.LONG;
        }
        return Type.DOUBLE;
    }
}

