/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.jmx;

import java.util.Date;
import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.jackrabbit.oak.api.jmx.CheckpointMBean;

public abstract class AbstractCheckpointMBean
implements CheckpointMBean {
    private static final String[] FIELD_NAMES = new String[]{"id", "created", "expires", "properties"};
    private static final String[] FIELD_DESCRIPTIONS = FIELD_NAMES;
    private static final OpenType[] FIELD_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, AbstractCheckpointMBean.createStringArrayType()};

    private static ArrayType<String> createStringArrayType() {
        try {
            return new ArrayType<String>(SimpleType.STRING, false);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
    }

    private CompositeType createCompositeType() {
        try {
            return new CompositeType(this.getTypeName(), "Checkpoints", FIELD_NAMES, FIELD_DESCRIPTIONS, FIELD_TYPES);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
    }

    protected abstract void collectCheckpoints(TabularDataSupport var1) throws OpenDataException;

    @Override
    public TabularData listCheckpoints() {
        try {
            TabularDataSupport tab = new TabularDataSupport(new TabularType(this.getTypeName(), "Checkpoints", this.createCompositeType(), new String[]{"id"}));
            this.collectCheckpoints(tab);
            return tab;
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public abstract long getOldestCheckpointCreationTimestamp();

    @Override
    public Date getOldestCheckpointCreationDate() {
        return new Date(this.getOldestCheckpointCreationTimestamp());
    }

    protected final CompositeDataSupport toCompositeData(String id, String created, String expires, Map<String, String> properties) throws OpenDataException {
        return new CompositeDataSupport(this.createCompositeType(), FIELD_NAMES, new Object[]{id, created, expires, AbstractCheckpointMBean.toArray(properties)});
    }

    private static String[] toArray(Map<String, String> properties) {
        String[] value = new String[properties.size()];
        int k = 0;
        for (Map.Entry<String, String> p : properties.entrySet()) {
            value[k++] = p.getKey() + '=' + p.getValue();
        }
        return value;
    }

    private String getTypeName() {
        return this.getClass().getName();
    }
}

