/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.SinglePropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.jetbrains.annotations.NotNull;
import sling-mock-oak.com.google.common.base.Preconditions;

public class StringPropertyState
extends SinglePropertyState<String> {
    private final String value;

    public StringPropertyState(@NotNull String name, @NotNull String value) {
        super(name);
        this.value = Preconditions.checkNotNull(value);
    }

    public static PropertyState stringProperty(@NotNull String name, @NotNull String value) {
        return new StringPropertyState(name, value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Conversions.Converter getConverter() {
        return Conversions.convert(this.value);
    }

    @Override
    public Type<?> getType() {
        return Type.STRING;
    }
}

