/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.token;

import java.security.Principal;
import java.util.Date;
import javax.jcr.Credentials;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.apache.jackrabbit.oak.security.authentication.token.TokenProviderImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.Authentication;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenInfo;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TokenAuthentication
implements Authentication {
    private static final Logger log = LoggerFactory.getLogger(TokenAuthentication.class);
    private final TokenProvider tokenProvider;
    private TokenInfo tokenInfo;

    TokenAuthentication(@NotNull TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    @Override
    public boolean authenticate(@Nullable Credentials credentials) throws LoginException {
        if (credentials instanceof TokenCredentials) {
            TokenCredentials tc = (TokenCredentials)credentials;
            if (!this.validateCredentials(tc)) {
                throw new LoginException("Invalid token credentials.");
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String getUserId() {
        if (this.tokenInfo == null) {
            throw new IllegalStateException("UserId can only be retrieved after successful authentication.");
        }
        return this.tokenInfo.getUserId();
    }

    @Override
    @Nullable
    public Principal getUserPrincipal() {
        if (this.tokenInfo == null) {
            throw new IllegalStateException("Token info can only be retrieved after successful authentication.");
        }
        if (this.tokenInfo instanceof TokenProviderImpl.TokenInfoImpl) {
            return ((TokenProviderImpl.TokenInfoImpl)this.tokenInfo).getPrincipal();
        }
        return null;
    }

    @NotNull
    TokenInfo getTokenInfo() {
        if (this.tokenInfo == null) {
            throw new IllegalStateException("Token info can only be retrieved after successful authentication.");
        }
        return this.tokenInfo;
    }

    private boolean validateCredentials(@NotNull TokenCredentials tokenCredentials) {
        String token = tokenCredentials.getToken();
        this.tokenInfo = this.tokenProvider.getTokenInfo(token);
        if (this.tokenInfo == null) {
            log.debug("No valid TokenInfo for token.");
            return false;
        }
        long loginTime = new Date().getTime();
        if (this.tokenInfo.isExpired(loginTime)) {
            log.debug("Token is expired");
            this.tokenInfo.remove();
            return false;
        }
        if (this.tokenInfo.matches(tokenCredentials)) {
            if (tokenCredentials.getAttribute("tokenSkipRefresh") == null) {
                boolean reset = this.tokenInfo.resetExpiration(loginTime);
                log.debug("Token reset={}", (Object)reset);
            } else {
                log.debug("Token reset skipped.");
            }
            return true;
        }
        return false;
    }
}

