/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.blob.stats;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.spi.blob.stats.BlobStatsCollector;
import org.jetbrains.annotations.NotNull;
import sling-mock-oak.com.google.common.io.CountingInputStream;

public final class StatsCollectingStreams {
    public static InputStream wrap(@NotNull BlobStatsCollector collector, String blobId, InputStream in) {
        return StatsCollectingStreams.wrap(collector, blobId, in, System.nanoTime());
    }

    public static InputStream wrap(final @NotNull BlobStatsCollector collector, final String blobId, InputStream in, final long startTime) {
        final CountingInputStream cin = new CountingInputStream(in);
        return new FilterInputStream(cin){

            @Override
            public void close() throws IOException {
                super.close();
                collector.downloaded(blobId, System.nanoTime() - startTime, TimeUnit.NANOSECONDS, cin.getCount());
                collector.downloadCompleted(blobId);
            }
        };
    }
}

