/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import java.util.Set;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import sling-mock-oak.com.google.common.base.Preconditions;
import sling-mock-oak.com.google.common.collect.Sets;

public class CompositeObserver
implements Observer {
    private final Set<Observer> observers = Sets.newIdentityHashSet();

    public synchronized void addObserver(@NotNull Observer observer) {
        Preconditions.checkState(this.observers.add(Preconditions.checkNotNull(observer)));
    }

    public synchronized void removeObserver(@NotNull Observer observer) {
        Preconditions.checkState(this.observers.remove(Preconditions.checkNotNull(observer)));
    }

    @Override
    public synchronized void contentChanged(@NotNull NodeState root, @NotNull CommitInfo info) {
        Preconditions.checkNotNull(root);
        for (Observer observer : this.observers) {
            observer.contentChanged(root, info);
        }
    }

    public synchronized String toString() {
        return this.observers.toString();
    }
}

