/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobSubmissionProtocol;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;

public class WebHCatJTShim20S
implements HadoopShims.WebHCatJTShim {
    private JobSubmissionProtocol cnx;

    public WebHCatJTShim20S(Configuration conf, UserGroupInformation ugi) throws IOException {
        this.cnx = (JobSubmissionProtocol)RPC.getProxy(JobSubmissionProtocol.class, (long)28L, (InetSocketAddress)this.getAddress(conf), (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getSocketFactory((Configuration)conf, JobSubmissionProtocol.class));
    }

    public JobProfile getJobProfile(JobID jobid) throws IOException {
        return this.cnx.getJobProfile(jobid);
    }

    public JobStatus getJobStatus(JobID jobid) throws IOException {
        return this.cnx.getJobStatus(jobid);
    }

    public void killJob(JobID jobid) throws IOException {
        this.cnx.killJob(jobid);
    }

    public JobStatus[] getAllJobs() throws IOException {
        return this.cnx.getAllJobs();
    }

    public void close() {
        RPC.stopProxy((VersionedProtocol)this.cnx);
    }

    private InetSocketAddress getAddress(Configuration conf) {
        String jobTrackerStr = conf.get("mapred.job.tracker", "localhost:8012");
        return NetUtils.createSocketAddr((String)jobTrackerStr);
    }

    public void addCacheFile(URI uri, Job job) {
        DistributedCache.addCacheFile((URI)uri, (Configuration)job.getConfiguration());
    }

    public void killJobs(String tag, long timestamp) {
    }
}

