/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import net.sf.jasperreports.engine.type.SortOrderEnum;

public class JRBaseSortField
implements JRSortField,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_ORDER = "order";
    protected String name;
    protected SortOrderEnum order = SortOrderEnum.ASCENDING;
    protected SortFieldTypeEnum type = SortFieldTypeEnum.FIELD;
    private transient JRPropertyChangeSupport eventSupport;

    protected JRBaseSortField() {
    }

    protected JRBaseSortField(JRSortField sortField, JRBaseObjectFactory factory) {
        factory.put(sortField, this);
        this.name = sortField.getName();
        this.order = sortField.getOrder();
        this.type = sortField.getType();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SortOrderEnum getOrder() {
        return this.order;
    }

    public void setOrder(SortOrderEnum order) {
        SortOrderEnum old = this.order;
        this.order = order;
        this.getEventSupport().firePropertyChange(PROPERTY_ORDER, old, this.order);
    }

    @Override
    public SortFieldTypeEnum getType() {
        return this.type;
    }

    @Override
    public Object clone() {
        try {
            JRBaseSortField clone = (JRBaseSortField)super.clone();
            clone.eventSupport = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseSortField jRBaseSortField = this;
        synchronized (jRBaseSortField) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

