/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.apache.tapestry5.internal.util.VirtualResource;
import org.apache.tapestry5.ioc.Resource;

public class UrlResource
extends VirtualResource {
    public static final URL PLACEHOLDER_URL;
    private final URL url;
    private Boolean exists;
    private InputStream inputStream;

    public UrlResource() {
        this(PLACEHOLDER_URL);
        this.exists = true;
    }

    public UrlResource(URL url) {
        this.url = url;
    }

    public InputStream openStream() throws IOException {
        if (this.exists == null) {
            try {
                this.inputStream = this.url.openStream();
                this.exists = true;
            }
            catch (IOException e) {
                this.exists = false;
                throw e;
            }
        }
        return this.inputStream;
    }

    @Override
    public URL toURL() {
        return this.url;
    }

    @Override
    public boolean exists() {
        if (this.exists == null) {
            try {
                this.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.exists;
    }

    @Override
    public Resource forLocale(Locale locale) {
        return this;
    }

    public String toString() {
        return "UrlResource [url=" + this.url + "]";
    }

    static {
        try {
            PLACEHOLDER_URL = new URL("http://tapestry.apache.org");
        }
        catch (MalformedURLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

