/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.javadoc;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import java.util.Map;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.Events;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.javadoc.ClassDescriptionSource;
import org.apache.tapestry5.javadoc.ParameterDescription;

public class ClassDescription {
    public final ClassDoc classDoc;
    public final Map<String, ParameterDescription> parameters = CollectionFactory.newCaseInsensitiveMap();
    public final Map<String, String> events = CollectionFactory.newCaseInsensitiveMap();

    public ClassDescription() {
        this.classDoc = null;
    }

    public ClassDescription(ClassDoc classDoc, ClassDescriptionSource source) {
        this.classDoc = classDoc;
        this.loadEvents();
        this.loadParameters(source);
        ClassDoc parentDoc = classDoc.superclass();
        if (parentDoc != null) {
            ClassDescription parentDescription = source.getDescription(classDoc.superclass().qualifiedName());
            ClassDescription.mergeInto(this.events, parentDescription.events);
            ClassDescription.mergeInto(this.parameters, parentDescription.parameters);
        }
    }

    private void loadEvents() {
        AnnotationValue[] values;
        AnnotationDesc eventsAnnotation = ClassDescription.getAnnotation((ProgramElementDoc)this.classDoc, Events.class);
        if (eventsAnnotation == null) {
            return;
        }
        AnnotationDesc.ElementValuePair pair = eventsAnnotation.elementValues()[0];
        AnnotationValue annotationValue = pair.value();
        for (AnnotationValue eventValue : values = (AnnotationValue[])annotationValue.value()) {
            String event = (String)eventValue.value();
            int ws = event.indexOf(32);
            String name = ws < 0 ? event : event.substring(0, ws);
            String description = ws < 0 ? "" : event.substring(ws + 1).trim();
            this.events.put(name, description);
        }
    }

    private static <K, V> void mergeInto(Map<K, V> target, Map<K, V> source) {
        for (K key : source.keySet()) {
            if (target.containsKey(key)) continue;
            V value = source.get(key);
            target.put(key, value);
        }
    }

    private void loadParameters(ClassDescriptionSource source) {
        for (FieldDoc fd : this.classDoc.fields(false)) {
            String names;
            if (fd.isStatic() || !fd.isPrivate()) continue;
            Map<String, String> values = ClassDescription.getAnnotationValues((ProgramElementDoc)fd, Parameter.class);
            if (values != null) {
                String name = values.get("name");
                if (name == null) {
                    name = fd.name().replaceAll("^[$_]*", "");
                }
                ParameterDescription pd = new ParameterDescription(fd, name, fd.type().qualifiedTypeName(), ClassDescription.get(values, "value", ""), ClassDescription.get(values, "defaultPrefix", "prop"), ClassDescription.getBoolean(values, "required", false), ClassDescription.getBoolean(values, "allowNull", true), ClassDescription.getBoolean(values, "cache", true), ClassDescription.getSinceTagValue((Doc)fd), ClassDescription.isDeprecated((ProgramElementDoc)fd));
                this.parameters.put(name, pd);
                continue;
            }
            values = ClassDescription.getAnnotationValues((ProgramElementDoc)fd, Component.class);
            if (values == null || InternalUtils.isBlank((String)(names = ClassDescription.get(values, "publishParameters", "")))) continue;
            for (String name : names.split("\\s*,\\s*")) {
                ParameterDescription pd = this.getPublishedParameterDescription(source, fd, name);
                this.parameters.put(name, pd);
            }
        }
    }

    private ParameterDescription getPublishedParameterDescription(ClassDescriptionSource source, FieldDoc fd, String name) {
        String currentClassName = fd.type().qualifiedTypeName();
        while (true) {
            ClassDescription componentCD = source.getDescription(currentClassName);
            if (componentCD.classDoc == null) {
                throw new IllegalArgumentException(String.format("Published parameter '%s' from %s not found.", name, fd.qualifiedName()));
            }
            if (componentCD.parameters.containsKey(name)) {
                return componentCD.parameters.get(name);
            }
            currentClassName = componentCD.classDoc.superclass().typeName();
        }
    }

    private static boolean isDeprecated(ProgramElementDoc doc) {
        return ClassDescription.getAnnotation(doc, Deprecated.class) != null || doc.tags("deprecated").length != 0;
    }

    private static String getSinceTagValue(Doc doc) {
        return ClassDescription.getTagValue(doc, "since");
    }

    private static String getTagValue(Doc doc, String tagName) {
        Tag[] tags = doc.tags(tagName);
        return 0 < tags.length ? tags[0].text() : "";
    }

    private static boolean getBoolean(Map<String, String> map, String key, boolean defaultValue) {
        if (map.containsKey(key)) {
            return Boolean.parseBoolean(map.get(key));
        }
        return defaultValue;
    }

    private static String get(Map<String, String> map, String key, String defaultValue) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return defaultValue;
    }

    private static AnnotationDesc getAnnotation(ProgramElementDoc source, Class annotationType) {
        String name = annotationType.getName();
        for (AnnotationDesc ad : source.annotations()) {
            if (!ad.annotationType().qualifiedTypeName().equals(name)) continue;
            return ad;
        }
        return null;
    }

    private static Map<String, String> getAnnotationValues(ProgramElementDoc source, Class annotationType) {
        AnnotationDesc annotation = ClassDescription.getAnnotation(source, annotationType);
        if (annotation == null) {
            return null;
        }
        Map result = CollectionFactory.newMap();
        for (AnnotationDesc.ElementValuePair pair : annotation.elementValues()) {
            result.put(pair.element().name(), pair.value().value().toString());
        }
        return result;
    }
}

