/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.sentdetect;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.SystemInputStreamFactory;
import opennlp.tools.cmdline.sentdetect.SentenceModelLoader;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ParagraphStream;
import opennlp.tools.util.PlainTextByLineStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SentenceDetectorTool
extends BasicCmdLineTool {
    private static final Logger logger = LoggerFactory.getLogger(SentenceDetectorTool.class);

    @Override
    public String getShortDescription() {
        return "Learnable sentence detector";
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model < sentences";
    }

    @Override
    public void run(String[] args) {
        if (args.length != 1) {
            logger.info(this.getHelp());
        } else {
            SentenceModel model = (SentenceModel)new SentenceModelLoader().load(new File(args[0]));
            SentenceDetectorME sdetector = new SentenceDetectorME(model);
            PerformanceMonitor perfMon = new PerformanceMonitor("sent");
            perfMon.start();
            try (ParagraphStream paraStream = new ParagraphStream(new PlainTextByLineStream((InputStreamFactory)new SystemInputStreamFactory(), SystemInputStreamFactory.encoding()));){
                String para;
                while ((para = (String)paraStream.read()) != null) {
                    String[] sents;
                    for (String sentence : sents = sdetector.sentDetect(para)) {
                        logger.info(sentence);
                    }
                    perfMon.incrementCounter(sents.length);
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError(e);
            }
            perfMon.stopAndPrintFinalResult();
        }
    }
}

