/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid.j2d;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sis.coverage.grid.j2d.ImageUtilities;
import org.apache.sis.coverage.grid.j2d.ObservableImage;
import org.apache.sis.coverage.grid.j2d.TileOpExecutor;
import org.apache.sis.coverage.grid.j2d.TiledImage;
import org.apache.sis.feature.internal.Resources;

public class WritableTiledImage
extends TiledImage
implements WritableRenderedImage {
    private volatile TileObserver[] observers;
    private final Map<Point, Integer> writables = new LinkedHashMap<Point, Integer>();

    public WritableTiledImage(Map<String, Object> properties, ColorModel colorModel, int width, int height, int minTileX, int minTileY, WritableRaster ... tiles) {
        super(properties, colorModel, width, height, minTileX, minTileY, tiles);
    }

    @Override
    public synchronized void addTileObserver(TileObserver observer) {
        this.observers = ObservableImage.addTileObserver(this.observers, observer);
    }

    @Override
    public synchronized void removeTileObserver(TileObserver observer) {
        this.observers = ObservableImage.removeTileObserver(this.observers, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WritableRaster getWritableTile(int tileX, int tileY) {
        Integer count;
        WritableRaster tile = (WritableRaster)super.getTile(tileX, tileY);
        Point key = new Point(tileX, tileY);
        Map<Point, Integer> map = this.writables;
        synchronized (map) {
            count = this.writables.merge(key, 1, (old, one) -> old + 1);
        }
        if (count <= 1) {
            ObservableImage.fireTileUpdate(this.observers, this, tileX, tileY, true);
        }
        return tile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseWritableTile(int tileX, int tileY) {
        boolean close;
        Integer count;
        Point key = new Point(tileX, tileY);
        Map<Point, Integer> map = this.writables;
        synchronized (map) {
            count = this.writables.computeIfPresent(key, (k, old) -> old - 1);
            boolean bl = close = count != null && count <= 0;
            if (close) {
                this.writables.remove(key);
            }
        }
        if (count == null) {
            throw new IllegalArgumentException(Resources.format((short)61, tileX, tileY));
        }
        if (close) {
            ObservableImage.fireTileUpdate(this.observers, this, tileX, tileY, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTileWritable(int tileX, int tileY) {
        Point key = new Point(tileX, tileY);
        Map<Point, Integer> map = this.writables;
        synchronized (map) {
            return this.writables.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point[] getWritableTileIndices() {
        Point[] indices;
        Map<Point, Integer> map = this.writables;
        synchronized (map) {
            int n = this.writables.size();
            if (n == 0) {
                return null;
            }
            indices = this.writables.keySet().toArray(new Point[n]);
        }
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = new Point(indices[i]);
        }
        return indices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasTileWriters() {
        Map<Point, Integer> map = this.writables;
        synchronized (map) {
            return !this.writables.isEmpty();
        }
    }

    @Override
    public void setData(final Raster data) {
        Rectangle bounds = data.getBounds();
        ImageUtilities.clipBounds(this, bounds);
        if (!bounds.isEmpty()) {
            TileOpExecutor op = new TileOpExecutor(this, bounds){

                @Override
                protected void writeTo(WritableRaster target) {
                    target.setRect(data);
                }
            };
            op.writeTo(this);
        }
    }
}

