/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.PopContaining;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.Writing;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.CallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.EventUtil;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.ListCallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class AddVertexStep<S>
extends ScalarMapStep<S, Vertex>
implements Writing<Event.VertexAddedEvent>,
TraversalParent,
Scoping {
    private Parameters parameters = new Parameters();
    private CallbackRegistry<Event.VertexAddedEvent> callbackRegistry;
    private boolean userProvidedLabel;

    public AddVertexStep(Traversal.Admin traversal, String label) {
        super(traversal);
        this.parameters.set(this, T.label, null == label ? "vertex" : label);
        this.userProvidedLabel = label != null;
    }

    public AddVertexStep(Traversal.Admin traversal, Traversal.Admin<S, String> vertexLabelTraversal) {
        super(traversal);
        this.parameters.set(this, T.label, null == vertexLabelTraversal ? "vertex" : vertexLabelTraversal);
        this.userProvidedLabel = vertexLabelTraversal != null;
    }

    public boolean hasUserProvidedLabel() {
        return this.userProvidedLabel;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public Set<String> getScopeKeys() {
        return this.parameters.getReferencedLabels();
    }

    @Override
    public HashSet<PopContaining.PopInstruction> getPopInstructions() {
        HashSet<PopContaining.PopInstruction> popInstructions = new HashSet<PopContaining.PopInstruction>();
        popInstructions.addAll(TraversalParent.super.getPopInstructions());
        return popInstructions;
    }

    @Override
    public <S, E> List<Traversal.Admin<S, E>> getLocalChildren() {
        return this.parameters.getTraversals();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void configure(Object ... keyValues) {
        if (keyValues[0] == T.label) {
            this.userProvidedLabel = true;
        }
        if (keyValues[0] == T.label && this.parameters.contains(T.label)) {
            if (!this.parameters.contains(T.label, "vertex")) throw new IllegalArgumentException(String.format("Vertex T.label has already been set to [%s] and cannot be overridden with [%s]", this.parameters.getRaw(new Object[0]).get(T.label).get(0), keyValues[1]));
            this.parameters.remove(T.label);
            this.parameters.set(this, keyValues);
            return;
        } else {
            if (keyValues[0] == T.id && this.parameters.contains(T.id)) {
                throw new IllegalArgumentException(String.format("Vertex T.id has already been set to [%s] and cannot be overridden with [%s]", this.parameters.getRaw(new Object[0]).get(T.id).get(0), keyValues[1]));
            }
            this.parameters.set(this, keyValues);
        }
    }

    @Override
    protected Vertex map(Traverser.Admin<S> traverser) {
        Vertex vertex = this.getTraversal().getGraph().get().addVertex(this.parameters.getKeyValues(traverser, new Object[0]));
        EventUtil.registerVertexCreation(this.callbackRegistry, this.getTraversal(), vertex);
        return vertex;
    }

    @Override
    public CallbackRegistry<Event.VertexAddedEvent> getMutatingCallbackRegistry() {
        if (null == this.callbackRegistry) {
            this.callbackRegistry = new ListCallbackRegistry<Event.VertexAddedEvent>();
        }
        return this.callbackRegistry;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.parameters.hashCode();
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(new TraverserRequirement[0]);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.parameters);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.parameters.getTraversals().forEach(this::integrateChild);
    }

    @Override
    public AddVertexStep<S> clone() {
        AddVertexStep clone = (AddVertexStep)super.clone();
        clone.parameters = this.parameters.clone();
        clone.userProvidedLabel = this.userProvidedLabel;
        return clone;
    }
}

