/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.decoration.VertexProgramStrategy;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.finalization.ComputerFinalizationStrategy;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.optimization.GraphFilterStrategy;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.optimization.MessagePassingReductionStrategy;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.verification.VertexProgramRestrictionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.DT;
import org.apache.tinkerpop.gremlin.process.traversal.GType;
import org.apache.tinkerpop.gremlin.process.traversal.Merge;
import org.apache.tinkerpop.gremlin.process.traversal.NotP;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Pick;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.ConnectiveStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.ElementIdStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.EventStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.HaltedTraverserStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.OptionsStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.PartitionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SeedStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SubgraphStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.finalization.MatchAlgorithmStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.finalization.ProfileStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.finalization.ReferenceElementStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.AdjacentToIncidentStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.ByModulatorOptimizationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.CountStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.EarlyLimitStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.FilterRankingStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.IdentityRemovalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.IncidentToAdjacentStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.InlineFilterStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.LazyBarrierStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.MatchPredicateStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.OrderLimitStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.PathProcessorStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.PathRetractionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.ProductiveByStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.RepeatUnrollStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ComputerVerificationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.EdgeLabelVerificationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.LambdaRestrictionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ReadOnlyStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ReservedKeysVerificationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.StandardVerificationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalExplanation;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONSerializersV1;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONSerializersV2;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONSerializersV3;
import org.apache.tinkerpop.gremlin.structure.io.graphson.JavaTimeSerializersV1;
import org.apache.tinkerpop.gremlin.structure.io.graphson.JavaUtilSerializersV1;
import org.apache.tinkerpop.gremlin.structure.io.graphson.JavaUtilSerializersV2;
import org.apache.tinkerpop.gremlin.structure.io.graphson.JavaUtilSerializersV3;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TinkerPopJacksonModule;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TraversalSerializersV2;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TraversalSerializersV3;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TypeInfo;
import org.apache.tinkerpop.gremlin.structure.util.star.DirectionalStarGraph;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraphGraphSONSerializerV1;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraphGraphSONSerializerV2;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraphGraphSONSerializerV3;
import org.apache.tinkerpop.gremlin.util.function.Lambda;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;

abstract class GraphSONModule
extends TinkerPopJacksonModule {
    GraphSONModule(String name) {
        super(name);
    }

    private static Optional<Class<?>> tryLoadSparqlStrategy() {
        try {
            return Optional.of(Class.forName("org.apache.tinkerpop.gremlin.sparql.process.traversal.strategy.SparqlStrategy"));
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }

    static interface GraphSONModuleBuilder {
        public GraphSONModule create(boolean var1, TypeInfo var2);
    }

    static final class GraphSONModuleV1
    extends GraphSONModule {
        protected GraphSONModuleV1(boolean normalize) {
            super("graphson-1.0");
            this.addSerializer(Edge.class, (JsonSerializer)new GraphSONSerializersV1.EdgeJacksonSerializer(normalize));
            this.addSerializer(Vertex.class, (JsonSerializer)new GraphSONSerializersV1.VertexJacksonSerializer(normalize));
            this.addSerializer(VertexProperty.class, (JsonSerializer)new GraphSONSerializersV1.VertexPropertyJacksonSerializer(normalize));
            this.addSerializer(Property.class, (JsonSerializer)new GraphSONSerializersV1.PropertyJacksonSerializer());
            this.addSerializer(TraversalMetrics.class, (JsonSerializer)new GraphSONSerializersV1.TraversalMetricsJacksonSerializer());
            this.addSerializer(TraversalExplanation.class, (JsonSerializer)new GraphSONSerializersV1.TraversalExplanationJacksonSerializer());
            this.addSerializer(Path.class, (JsonSerializer)new GraphSONSerializersV1.PathJacksonSerializer());
            this.addSerializer(DirectionalStarGraph.class, (JsonSerializer)new StarGraphGraphSONSerializerV1(normalize));
            this.addSerializer(Tree.class, (JsonSerializer)new GraphSONSerializersV1.TreeJacksonSerializer());
            this.addSerializer(Map.Entry.class, (JsonSerializer)new JavaUtilSerializersV1.MapEntryJacksonSerializer());
            this.addSerializer(Duration.class, (JsonSerializer)new JavaTimeSerializersV1.DurationJacksonSerializer());
            this.addSerializer(Instant.class, (JsonSerializer)new JavaTimeSerializersV1.InstantJacksonSerializer());
            this.addSerializer(LocalDate.class, (JsonSerializer)new JavaTimeSerializersV1.LocalDateJacksonSerializer());
            this.addSerializer(LocalDateTime.class, (JsonSerializer)new JavaTimeSerializersV1.LocalDateTimeJacksonSerializer());
            this.addSerializer(LocalTime.class, (JsonSerializer)new JavaTimeSerializersV1.LocalTimeJacksonSerializer());
            this.addSerializer(MonthDay.class, (JsonSerializer)new JavaTimeSerializersV1.MonthDayJacksonSerializer());
            this.addSerializer(OffsetDateTime.class, (JsonSerializer)new JavaTimeSerializersV1.OffsetDateTimeJacksonSerializer());
            this.addSerializer(OffsetTime.class, (JsonSerializer)new JavaTimeSerializersV1.OffsetTimeJacksonSerializer());
            this.addSerializer(Period.class, (JsonSerializer)new JavaTimeSerializersV1.PeriodJacksonSerializer());
            this.addSerializer(Year.class, (JsonSerializer)new JavaTimeSerializersV1.YearJacksonSerializer());
            this.addSerializer(YearMonth.class, (JsonSerializer)new JavaTimeSerializersV1.YearMonthJacksonSerializer());
            this.addSerializer(ZonedDateTime.class, (JsonSerializer)new JavaTimeSerializersV1.ZonedDateTimeJacksonSerializer());
            this.addSerializer(ZoneOffset.class, (JsonSerializer)new JavaTimeSerializersV1.ZoneOffsetJacksonSerializer());
            this.addDeserializer(Duration.class, (JsonDeserializer)new JavaTimeSerializersV1.DurationJacksonDeserializer());
            this.addDeserializer(Instant.class, (JsonDeserializer)new JavaTimeSerializersV1.InstantJacksonDeserializer());
            this.addDeserializer(LocalDate.class, (JsonDeserializer)new JavaTimeSerializersV1.LocalDateJacksonDeserializer());
            this.addDeserializer(LocalDateTime.class, (JsonDeserializer)new JavaTimeSerializersV1.LocalDateTimeJacksonDeserializer());
            this.addDeserializer(LocalTime.class, (JsonDeserializer)new JavaTimeSerializersV1.LocalTimeJacksonDeserializer());
            this.addDeserializer(MonthDay.class, (JsonDeserializer)new JavaTimeSerializersV1.MonthDayJacksonDeserializer());
            this.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new JavaTimeSerializersV1.OffsetDateTimeJacksonDeserializer());
            this.addDeserializer(OffsetTime.class, (JsonDeserializer)new JavaTimeSerializersV1.OffsetTimeJacksonDeserializer());
            this.addDeserializer(Period.class, (JsonDeserializer)new JavaTimeSerializersV1.PeriodJacksonDeserializer());
            this.addDeserializer(Year.class, (JsonDeserializer)new JavaTimeSerializersV1.YearJacksonDeserializer());
            this.addDeserializer(YearMonth.class, (JsonDeserializer)new JavaTimeSerializersV1.YearMonthJacksonDeserializer());
            this.addDeserializer(ZonedDateTime.class, (JsonDeserializer)new JavaTimeSerializersV1.ZonedDateTimeJacksonDeserializer());
            this.addDeserializer(ZoneOffset.class, (JsonDeserializer)new JavaTimeSerializersV1.ZoneOffsetJacksonDeserializer());
        }

        public static Builder build() {
            return new Builder();
        }

        @Override
        public Map<Class, String> getTypeDefinitions() {
            return null;
        }

        @Override
        public String getTypeNamespace() {
            return null;
        }

        static final class Builder
        implements GraphSONModuleBuilder {
            private Builder() {
            }

            @Override
            public GraphSONModule create(boolean normalize, TypeInfo typeInfo) {
                return new GraphSONModuleV1(normalize);
            }
        }
    }

    static final class GraphSONModuleV2
    extends GraphSONModule {
        private static final Map<Class, String> TYPE_DEFINITIONS = Collections.unmodifiableMap(new LinkedHashMap<Class, String>(){
            {
                this.put(Integer.class, "Int32");
                this.put(Long.class, "Int64");
                this.put(Double.class, "Double");
                this.put(Float.class, "Float");
                this.put(Lambda.class, "Lambda");
                this.put(Vertex.class, "Vertex");
                this.put(Edge.class, "Edge");
                this.put(Property.class, "Property");
                this.put(Path.class, "Path");
                this.put(VertexProperty.class, "VertexProperty");
                this.put(Metrics.class, "Metrics");
                this.put(TraversalMetrics.class, "TraversalMetrics");
                this.put(TraversalExplanation.class, "TraversalExplanation");
                this.put(Traverser.class, "Traverser");
                this.put(Tree.class, "Tree");
                this.put(Bytecode.class, "Bytecode");
                this.put(Bytecode.Binding.class, "Binding");
                this.put(AndP.class, "P");
                this.put(OrP.class, "P");
                this.put(NotP.class, "P");
                this.put(P.class, "P");
                this.put(TextP.class, "TextP");
                this.put(TraversalStrategyProxy.class, "TraversalStrategy");
                Stream.of(VertexProperty.Cardinality.class, Column.class, Direction.class, DT.class, Merge.class, GType.class, Operator.class, Order.class, Pop.class, SackFunctions.Barrier.class, Pick.class, Scope.class, T.class).forEach((? super T e) -> this.put(e, e.getSimpleName()));
                Arrays.asList(ConnectiveStrategy.class, ElementIdStrategy.class, EventStrategy.class, HaltedTraverserStrategy.class, PartitionStrategy.class, SubgraphStrategy.class, SeedStrategy.class, LazyBarrierStrategy.class, MatchAlgorithmStrategy.class, AdjacentToIncidentStrategy.class, ByModulatorOptimizationStrategy.class, ProductiveByStrategy.class, CountStrategy.class, FilterRankingStrategy.class, IdentityRemovalStrategy.class, IncidentToAdjacentStrategy.class, InlineFilterStrategy.class, MatchPredicateStrategy.class, OrderLimitStrategy.class, OptionsStrategy.class, PathProcessorStrategy.class, PathRetractionStrategy.class, RepeatUnrollStrategy.class, ComputerVerificationStrategy.class, LambdaRestrictionStrategy.class, ReadOnlyStrategy.class, StandardVerificationStrategy.class, EarlyLimitStrategy.class, EdgeLabelVerificationStrategy.class, ReservedKeysVerificationStrategy.class, ReferenceElementStrategy.class, ComputerFinalizationStrategy.class, MessagePassingReductionStrategy.class, ProfileStrategy.class, VertexProgramRestrictionStrategy.class, GraphFilterStrategy.class, VertexProgramStrategy.class).forEach((? super T strategy) -> this.put(strategy, strategy.getSimpleName()));
                GraphSONModule.tryLoadSparqlStrategy().ifPresent(s -> this.put(s, s.getSimpleName()));
            }
        });

        protected GraphSONModuleV2(boolean normalize) {
            super("graphson-2.0");
            this.addSerializer(Edge.class, (JsonSerializer)new GraphSONSerializersV2.EdgeJacksonSerializer(normalize));
            this.addSerializer(Vertex.class, (JsonSerializer)new GraphSONSerializersV2.VertexJacksonSerializer(normalize));
            this.addSerializer(VertexProperty.class, (JsonSerializer)new GraphSONSerializersV2.VertexPropertyJacksonSerializer(normalize, true));
            this.addSerializer(Property.class, (JsonSerializer)new GraphSONSerializersV2.PropertyJacksonSerializer());
            this.addSerializer(Metrics.class, (JsonSerializer)new GraphSONSerializersV2.MetricsJacksonSerializer());
            this.addSerializer(TraversalMetrics.class, (JsonSerializer)new GraphSONSerializersV2.TraversalMetricsJacksonSerializer());
            this.addSerializer(TraversalExplanation.class, (JsonSerializer)new GraphSONSerializersV2.TraversalExplanationJacksonSerializer());
            this.addSerializer(Path.class, (JsonSerializer)new GraphSONSerializersV2.PathJacksonSerializer());
            this.addSerializer(DirectionalStarGraph.class, (JsonSerializer)new StarGraphGraphSONSerializerV2(normalize));
            this.addSerializer(Tree.class, (JsonSerializer)new GraphSONSerializersV2.TreeJacksonSerializer());
            this.addSerializer(Map.Entry.class, (JsonSerializer)new JavaUtilSerializersV2.MapEntryJacksonSerializer());
            this.addSerializer(Integer.class, (JsonSerializer)new GraphSONSerializersV2.IntegerGraphSONSerializer());
            this.addSerializer(Double.class, (JsonSerializer)new GraphSONSerializersV2.DoubleGraphSONSerializer());
            this.addSerializer(Traversal.class, (JsonSerializer)new TraversalSerializersV2.TraversalJacksonSerializer());
            this.addSerializer(Bytecode.class, (JsonSerializer)new TraversalSerializersV2.BytecodeJacksonSerializer());
            Stream.of(VertexProperty.Cardinality.class, Column.class, Direction.class, DT.class, GType.class, Merge.class, Operator.class, Order.class, Pop.class, SackFunctions.Barrier.class, Scope.class, Pick.class, T.class).forEach(e -> this.addSerializer((Class)e, (JsonSerializer)new TraversalSerializersV2.EnumJacksonSerializer()));
            this.addSerializer(P.class, (JsonSerializer)new TraversalSerializersV2.PJacksonSerializer());
            this.addSerializer(Lambda.class, (JsonSerializer)new TraversalSerializersV2.LambdaJacksonSerializer());
            this.addSerializer(Bytecode.Binding.class, (JsonSerializer)new TraversalSerializersV2.BindingJacksonSerializer());
            this.addSerializer(Traverser.class, (JsonSerializer)new TraversalSerializersV2.TraverserJacksonSerializer());
            this.addSerializer(TraversalStrategy.class, (JsonSerializer)new TraversalSerializersV2.TraversalStrategyJacksonSerializer());
            this.addDeserializer(Vertex.class, (JsonDeserializer)new GraphSONSerializersV2.VertexJacksonDeserializer());
            this.addDeserializer(Edge.class, (JsonDeserializer)new GraphSONSerializersV2.EdgeJacksonDeserializer());
            this.addDeserializer(Property.class, (JsonDeserializer)new GraphSONSerializersV2.PropertyJacksonDeserializer());
            this.addDeserializer(Path.class, (JsonDeserializer)new GraphSONSerializersV2.PathJacksonDeserializer());
            this.addDeserializer(VertexProperty.class, (JsonDeserializer)new GraphSONSerializersV2.VertexPropertyJacksonDeserializer());
            this.addDeserializer(TraversalExplanation.class, (JsonDeserializer)new GraphSONSerializersV2.TraversalExplanationJacksonDeserializer());
            this.addDeserializer(Metrics.class, (JsonDeserializer)new GraphSONSerializersV2.MetricsJacksonDeserializer());
            this.addDeserializer(TraversalMetrics.class, (JsonDeserializer)new GraphSONSerializersV2.TraversalMetricsJacksonDeserializer());
            this.addDeserializer(Tree.class, (JsonDeserializer)new GraphSONSerializersV2.TreeJacksonDeserializer());
            this.addDeserializer(TraversalStrategyProxy.class, (JsonDeserializer)new TraversalSerializersV2.TraversalStrategyProxyJacksonDeserializer());
            this.addDeserializer(Integer.class, (JsonDeserializer)new GraphSONSerializersV2.IntegerJacksonDeserializer());
            this.addDeserializer(Double.class, (JsonDeserializer)new GraphSONSerializersV2.DoubleJacksonDeserializer());
            this.addDeserializer(Bytecode.class, (JsonDeserializer)new TraversalSerializersV2.BytecodeJacksonDeserializer());
            this.addDeserializer(Bytecode.Binding.class, (JsonDeserializer)new TraversalSerializersV2.BindingJacksonDeserializer());
            Stream.of(new Enum[][]{VertexProperty.Cardinality.values(), Column.values(), Direction.values(), DT.values(), GType.values(), Merge.values(), Operator.values(), Order.values(), Pop.values(), SackFunctions.Barrier.values(), Scope.values(), Pick.values(), T.values()}).flatMap(Stream::of).forEach(e -> this.addDeserializer(e.getClass(), (JsonDeserializer)new TraversalSerializersV2.EnumJacksonDeserializer(e.getDeclaringClass())));
            this.addDeserializer(P.class, (JsonDeserializer)new TraversalSerializersV2.PJacksonDeserializer());
            this.addDeserializer(TextP.class, (JsonDeserializer)new TraversalSerializersV2.TextPJacksonDeserializer());
            this.addDeserializer(Lambda.class, (JsonDeserializer)new TraversalSerializersV2.LambdaJacksonDeserializer());
            this.addDeserializer(Traverser.class, (JsonDeserializer)new TraversalSerializersV2.TraverserJacksonDeserializer());
            Arrays.asList(ConnectiveStrategy.class, ElementIdStrategy.class, EventStrategy.class, HaltedTraverserStrategy.class, PartitionStrategy.class, SubgraphStrategy.class, SeedStrategy.class, LazyBarrierStrategy.class, MatchAlgorithmStrategy.class, AdjacentToIncidentStrategy.class, ByModulatorOptimizationStrategy.class, ProductiveByStrategy.class, CountStrategy.class, FilterRankingStrategy.class, IdentityRemovalStrategy.class, IncidentToAdjacentStrategy.class, InlineFilterStrategy.class, MatchPredicateStrategy.class, OrderLimitStrategy.class, OptionsStrategy.class, PathProcessorStrategy.class, PathRetractionStrategy.class, RepeatUnrollStrategy.class, ComputerVerificationStrategy.class, LambdaRestrictionStrategy.class, ReadOnlyStrategy.class, StandardVerificationStrategy.class, EarlyLimitStrategy.class, EdgeLabelVerificationStrategy.class, ReservedKeysVerificationStrategy.class, ReferenceElementStrategy.class, ComputerFinalizationStrategy.class, MessagePassingReductionStrategy.class, ProfileStrategy.class, VertexProgramRestrictionStrategy.class, GraphFilterStrategy.class, VertexProgramStrategy.class).forEach(strategy -> this.addDeserializer((Class)strategy, (JsonDeserializer)new TraversalSerializersV2.TraversalStrategyProxyJacksonDeserializer(strategy)));
            GraphSONModule.tryLoadSparqlStrategy().ifPresent(s -> this.addDeserializer((Class)s, (JsonDeserializer)new TraversalSerializersV2.TraversalStrategyProxyJacksonDeserializer(s)));
        }

        public static Builder build() {
            return new Builder();
        }

        @Override
        public Map<Class, String> getTypeDefinitions() {
            return TYPE_DEFINITIONS;
        }

        @Override
        public String getTypeNamespace() {
            return "g";
        }

        static final class Builder
        implements GraphSONModuleBuilder {
            private Builder() {
            }

            @Override
            public GraphSONModule create(boolean normalize, TypeInfo typeInfo) {
                return new GraphSONModuleV2(normalize);
            }
        }
    }

    static final class GraphSONModuleV3
    extends GraphSONModule {
        private static final Map<Class, String> TYPE_DEFINITIONS = Collections.unmodifiableMap(new LinkedHashMap<Class, String>(){
            {
                this.put(Integer.class, "Int32");
                this.put(Long.class, "Int64");
                this.put(Double.class, "Double");
                this.put(Float.class, "Float");
                this.put(Map.class, "Map");
                this.put(List.class, "List");
                this.put(Set.class, "Set");
                this.put(Lambda.class, "Lambda");
                this.put(Vertex.class, "Vertex");
                this.put(Edge.class, "Edge");
                this.put(Property.class, "Property");
                this.put(Path.class, "Path");
                this.put(VertexProperty.class, "VertexProperty");
                this.put(Metrics.class, "Metrics");
                this.put(TraversalMetrics.class, "TraversalMetrics");
                this.put(TraversalExplanation.class, "TraversalExplanation");
                this.put(Traverser.class, "Traverser");
                this.put(Tree.class, "Tree");
                this.put(BulkSet.class, "BulkSet");
                this.put(Bytecode.class, "Bytecode");
                this.put(Bytecode.Binding.class, "Binding");
                this.put(AndP.class, "P");
                this.put(OrP.class, "P");
                this.put(NotP.class, "P");
                this.put(P.class, "P");
                this.put(TextP.class, "TextP");
                this.put(TraversalStrategyProxy.class, "TraversalStrategy");
                Stream.of(VertexProperty.Cardinality.class, Column.class, Direction.class, DT.class, Merge.class, GType.class, Operator.class, Order.class, Pop.class, SackFunctions.Barrier.class, Pick.class, Scope.class, T.class).forEach((? super T e) -> this.put(e, e.getSimpleName()));
                Arrays.asList(ConnectiveStrategy.class, ElementIdStrategy.class, EventStrategy.class, HaltedTraverserStrategy.class, PartitionStrategy.class, SubgraphStrategy.class, SeedStrategy.class, LazyBarrierStrategy.class, MatchAlgorithmStrategy.class, AdjacentToIncidentStrategy.class, ByModulatorOptimizationStrategy.class, ProductiveByStrategy.class, CountStrategy.class, FilterRankingStrategy.class, IdentityRemovalStrategy.class, IncidentToAdjacentStrategy.class, InlineFilterStrategy.class, MatchPredicateStrategy.class, OrderLimitStrategy.class, OptionsStrategy.class, PathProcessorStrategy.class, PathRetractionStrategy.class, RepeatUnrollStrategy.class, ComputerVerificationStrategy.class, LambdaRestrictionStrategy.class, ReadOnlyStrategy.class, StandardVerificationStrategy.class, EarlyLimitStrategy.class, EdgeLabelVerificationStrategy.class, ReservedKeysVerificationStrategy.class, ReferenceElementStrategy.class, ComputerFinalizationStrategy.class, MessagePassingReductionStrategy.class, ProfileStrategy.class, VertexProgramRestrictionStrategy.class, GraphFilterStrategy.class, VertexProgramStrategy.class).forEach((? super T strategy) -> this.put(strategy, strategy.getSimpleName()));
                GraphSONModule.tryLoadSparqlStrategy().ifPresent(s -> this.put(s, s.getSimpleName()));
            }
        });

        protected GraphSONModuleV3(boolean normalize, TypeInfo typeInfo) {
            super("graphson-3.0");
            this.addSerializer(Edge.class, (JsonSerializer)new GraphSONSerializersV3.EdgeJacksonSerializer(normalize, typeInfo));
            this.addSerializer(Vertex.class, (JsonSerializer)new GraphSONSerializersV3.VertexJacksonSerializer(normalize, typeInfo));
            this.addSerializer(VertexProperty.class, (JsonSerializer)new GraphSONSerializersV3.VertexPropertyJacksonSerializer(normalize, true));
            this.addSerializer(Property.class, (JsonSerializer)new GraphSONSerializersV3.PropertyJacksonSerializer());
            this.addSerializer(Metrics.class, (JsonSerializer)new GraphSONSerializersV3.MetricsJacksonSerializer());
            this.addSerializer(TraversalMetrics.class, (JsonSerializer)new GraphSONSerializersV3.TraversalMetricsJacksonSerializer());
            this.addSerializer(TraversalExplanation.class, (JsonSerializer)new GraphSONSerializersV3.TraversalExplanationJacksonSerializer());
            this.addSerializer(Path.class, (JsonSerializer)new GraphSONSerializersV3.PathJacksonSerializer());
            this.addSerializer(DirectionalStarGraph.class, (JsonSerializer)new StarGraphGraphSONSerializerV3(normalize));
            this.addSerializer(Tree.class, (JsonSerializer)new GraphSONSerializersV3.TreeJacksonSerializer());
            if (typeInfo != TypeInfo.NO_TYPES) {
                this.addSerializer(Map.Entry.class, (JsonSerializer)new JavaUtilSerializersV3.MapEntryJacksonSerializer());
                this.addSerializer(Map.class, (JsonSerializer)new JavaUtilSerializersV3.MapJacksonSerializer());
                this.addSerializer(List.class, (JsonSerializer)new JavaUtilSerializersV3.ListJacksonSerializer());
                this.addSerializer(Set.class, (JsonSerializer)new JavaUtilSerializersV3.SetJacksonSerializer());
            }
            this.addSerializer(Integer.class, (JsonSerializer)new GraphSONSerializersV3.IntegerGraphSONSerializer());
            this.addSerializer(Double.class, (JsonSerializer)new GraphSONSerializersV3.DoubleGraphSONSerializer());
            this.addSerializer(BulkSet.class, (JsonSerializer)new TraversalSerializersV3.BulkSetJacksonSerializer());
            this.addSerializer(Traversal.class, (JsonSerializer)new TraversalSerializersV3.TraversalJacksonSerializer());
            this.addSerializer(Bytecode.class, (JsonSerializer)new TraversalSerializersV3.BytecodeJacksonSerializer());
            Stream.of(VertexProperty.Cardinality.class, Column.class, Direction.class, DT.class, GType.class, Merge.class, Operator.class, Order.class, Pop.class, SackFunctions.Barrier.class, Scope.class, Pick.class, T.class).forEach(e -> this.addSerializer((Class)e, (JsonSerializer)new TraversalSerializersV3.EnumJacksonSerializer()));
            this.addSerializer(P.class, (JsonSerializer)new TraversalSerializersV3.PJacksonSerializer());
            this.addSerializer(Lambda.class, (JsonSerializer)new TraversalSerializersV3.LambdaJacksonSerializer());
            this.addSerializer(Bytecode.Binding.class, (JsonSerializer)new TraversalSerializersV3.BindingJacksonSerializer());
            this.addSerializer(Traverser.class, (JsonSerializer)new TraversalSerializersV3.TraverserJacksonSerializer());
            this.addSerializer(TraversalStrategy.class, (JsonSerializer)new TraversalSerializersV3.TraversalStrategyJacksonSerializer());
            this.addDeserializer(Vertex.class, (JsonDeserializer)new GraphSONSerializersV3.VertexJacksonDeserializer());
            this.addDeserializer(Edge.class, (JsonDeserializer)new GraphSONSerializersV3.EdgeJacksonDeserializer());
            this.addDeserializer(Property.class, (JsonDeserializer)new GraphSONSerializersV3.PropertyJacksonDeserializer());
            this.addDeserializer(Path.class, (JsonDeserializer)new GraphSONSerializersV3.PathJacksonDeserializer());
            this.addDeserializer(TraversalExplanation.class, (JsonDeserializer)new GraphSONSerializersV3.TraversalExplanationJacksonDeserializer());
            this.addDeserializer(VertexProperty.class, (JsonDeserializer)new GraphSONSerializersV3.VertexPropertyJacksonDeserializer());
            this.addDeserializer(Metrics.class, (JsonDeserializer)new GraphSONSerializersV3.MetricsJacksonDeserializer());
            this.addDeserializer(TraversalMetrics.class, (JsonDeserializer)new GraphSONSerializersV3.TraversalMetricsJacksonDeserializer());
            this.addDeserializer(Tree.class, (JsonDeserializer)new GraphSONSerializersV3.TreeJacksonDeserializer());
            this.addDeserializer(TraversalStrategyProxy.class, (JsonDeserializer)new TraversalSerializersV3.TraversalStrategyProxyJacksonDeserializer());
            if (typeInfo != TypeInfo.NO_TYPES) {
                this.addDeserializer(Map.class, (JsonDeserializer)new JavaUtilSerializersV3.MapJacksonDeserializer());
                this.addDeserializer(List.class, (JsonDeserializer)new JavaUtilSerializersV3.ListJacksonDeserializer());
                this.addDeserializer(Set.class, (JsonDeserializer)new JavaUtilSerializersV3.SetJacksonDeserializer());
            }
            this.addDeserializer(Integer.class, (JsonDeserializer)new GraphSONSerializersV3.IntegerJackonsDeserializer());
            this.addDeserializer(Double.class, (JsonDeserializer)new GraphSONSerializersV3.DoubleJacksonDeserializer());
            this.addDeserializer(BulkSet.class, (JsonDeserializer)new TraversalSerializersV3.BulkSetJacksonDeserializer());
            this.addDeserializer(Bytecode.class, (JsonDeserializer)new TraversalSerializersV3.BytecodeJacksonDeserializer());
            this.addDeserializer(Bytecode.Binding.class, (JsonDeserializer)new TraversalSerializersV3.BindingJacksonDeserializer());
            Stream.of(new Enum[][]{VertexProperty.Cardinality.values(), Column.values(), Direction.values(), DT.values(), Merge.values(), GType.values(), Operator.values(), Order.values(), Pop.values(), SackFunctions.Barrier.values(), Scope.values(), Pick.values(), T.values()}).flatMap(Stream::of).forEach(e -> this.addDeserializer(e.getClass(), (JsonDeserializer)new TraversalSerializersV3.EnumJacksonDeserializer(e.getDeclaringClass())));
            this.addDeserializer(P.class, (JsonDeserializer)new TraversalSerializersV3.PJacksonDeserializer());
            this.addDeserializer(TextP.class, (JsonDeserializer)new TraversalSerializersV3.TextPJacksonDeserializer());
            this.addDeserializer(Lambda.class, (JsonDeserializer)new TraversalSerializersV3.LambdaJacksonDeserializer());
            this.addDeserializer(Traverser.class, (JsonDeserializer)new TraversalSerializersV3.TraverserJacksonDeserializer());
            Arrays.asList(ConnectiveStrategy.class, ElementIdStrategy.class, EventStrategy.class, HaltedTraverserStrategy.class, PartitionStrategy.class, SubgraphStrategy.class, SeedStrategy.class, LazyBarrierStrategy.class, MatchAlgorithmStrategy.class, AdjacentToIncidentStrategy.class, ByModulatorOptimizationStrategy.class, ProductiveByStrategy.class, CountStrategy.class, FilterRankingStrategy.class, IdentityRemovalStrategy.class, IncidentToAdjacentStrategy.class, InlineFilterStrategy.class, MatchPredicateStrategy.class, OrderLimitStrategy.class, OptionsStrategy.class, PathProcessorStrategy.class, PathRetractionStrategy.class, RepeatUnrollStrategy.class, ComputerVerificationStrategy.class, LambdaRestrictionStrategy.class, ReadOnlyStrategy.class, StandardVerificationStrategy.class, EarlyLimitStrategy.class, EdgeLabelVerificationStrategy.class, ReservedKeysVerificationStrategy.class, ReferenceElementStrategy.class, ComputerFinalizationStrategy.class, MessagePassingReductionStrategy.class, ProfileStrategy.class, VertexProgramRestrictionStrategy.class, GraphFilterStrategy.class, VertexProgramStrategy.class).forEach(strategy -> this.addDeserializer((Class)strategy, (JsonDeserializer)new TraversalSerializersV3.TraversalStrategyProxyJacksonDeserializer(strategy)));
            GraphSONModule.tryLoadSparqlStrategy().ifPresent(s -> this.addDeserializer((Class)s, (JsonDeserializer)new TraversalSerializersV3.TraversalStrategyProxyJacksonDeserializer(s)));
        }

        public static Builder build() {
            return new Builder();
        }

        @Override
        public Map<Class, String> getTypeDefinitions() {
            return TYPE_DEFINITIONS;
        }

        @Override
        public String getTypeNamespace() {
            return "g";
        }

        static final class Builder
        implements GraphSONModuleBuilder {
            private Builder() {
            }

            @Override
            public GraphSONModule create(boolean normalize, TypeInfo typeInfo) {
                return new GraphSONModuleV3(normalize, typeInfo);
            }
        }
    }
}

