/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.internal;

import java.net.MalformedURLException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.UimaContextHolder;
import org.apache.uima.impl.UimaVersion;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.springframework.util.ClassUtils;

public class ResourceManagerFactory {
    private static ResourceManagerCreator resourceManagerCreator = new DefaultResourceManagerCreator();

    private ResourceManagerFactory() {
    }

    public static ResourceManager newResourceManager() throws ResourceInitializationException {
        return resourceManagerCreator.newResourceManager();
    }

    public static synchronized void setResourceManagerCreator(ResourceManagerCreator resourceManagerCreator) {
        ResourceManagerFactory.resourceManagerCreator = resourceManagerCreator;
    }

    public static ResourceManagerCreator getResourceManagerCreator() {
        return resourceManagerCreator;
    }

    public static class DefaultResourceManagerCreator
    implements ResourceManagerCreator {
        @Override
        public ResourceManager newResourceManager() throws ResourceInitializationException {
            try {
                boolean uimaCoreIgnoresContextClassloader;
                UimaContext activeContext = UimaContextHolder.getContext();
                if (activeContext != null) {
                    return ((UimaContextAdmin)activeContext).getResourceManager();
                }
                ResourceManager resMgr = UIMAFramework.newDefaultResourceManager();
                short maj = UimaVersion.getMajorVersion();
                short min = UimaVersion.getMinorVersion();
                short rev = UimaVersion.getBuildRevision();
                boolean bl = uimaCoreIgnoresContextClassloader = maj == 2 && (min < 10 || min == 10 && rev < 3) || maj == 3 && min == 0 && rev < 1;
                if (uimaCoreIgnoresContextClassloader) {
                    resMgr.setExtensionClassPath(ClassUtils.getDefaultClassLoader(), "", true);
                }
                return resMgr;
            }
            catch (MalformedURLException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        }
    }

    public static interface ResourceManagerCreator {
        public ResourceManager newResourceManager() throws ResourceInitializationException;
    }
}

