/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.internal.Characters;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractCharacterAssert<SELF extends AbstractCharacterAssert<SELF>>
extends AbstractComparableAssert<SELF, Character> {
    @VisibleForTesting
    Characters characters = Characters.instance();

    public AbstractCharacterAssert(Character actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isEqualTo(char expected) {
        this.characters.assertEqual(this.info, (Character)this.actual, Character.valueOf(expected));
        return (SELF)((AbstractCharacterAssert)this.myself);
    }

    public SELF isNotEqualTo(char other) {
        this.characters.assertNotEqual(this.info, (Character)this.actual, Character.valueOf(other));
        return (SELF)((AbstractCharacterAssert)this.myself);
    }

    @Override
    public SELF isLessThan(char other) {
        this.characters.assertLessThan(this.info, (Character)this.actual, Character.valueOf(other));
        return (SELF)((AbstractCharacterAssert)this.myself);
    }

    @Override
    public SELF isLessThanOrEqualTo(char other) {
        this.characters.assertLessThanOrEqualTo(this.info, (Character)this.actual, Character.valueOf(other));
        return (SELF)((AbstractCharacterAssert)this.myself);
    }

    @Override
    public SELF isGreaterThan(char other) {
        this.characters.assertGreaterThan(this.info, (Character)this.actual, Character.valueOf(other));
        return (SELF)((AbstractCharacterAssert)this.myself);
    }

    @CheckReturnValue
    public SELF inUnicode() {
        this.info.useUnicodeRepresentation();
        return (SELF)((AbstractCharacterAssert)this.myself);
    }

    @Override
    public SELF isGreaterThanOrEqualTo(char other) {
        this.characters.assertGreaterThanOrEqualTo(this.info, (Character)this.actual, Character.valueOf(other));
        return (SELF)((AbstractCharacterAssert)this.myself);
    }

    public SELF isLowerCase() {
        this.characters.assertLowerCase(this.info, (Character)this.actual);
        return (SELF)((AbstractCharacterAssert)this.myself);
    }

    public SELF isUpperCase() {
        this.characters.assertUpperCase(this.info, (Character)this.actual);
        return (SELF)((AbstractCharacterAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super Character> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super Character> customComparator, String customComparatorDescription) {
        this.characters = new Characters(new ComparatorBasedComparisonStrategy(customComparator, customComparatorDescription));
        return (SELF)((AbstractCharacterAssert)super.usingComparator(customComparator, customComparatorDescription));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        this.characters = Characters.instance();
        return (SELF)((AbstractCharacterAssert)super.usingDefaultComparator());
    }
}

