/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ShouldNotHaveThrown;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Throwables;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractThrowableAssert<SELF extends AbstractThrowableAssert<SELF, ACTUAL>, ACTUAL extends Throwable>
extends AbstractObjectAssert<SELF, ACTUAL> {
    @VisibleForTesting
    Throwables throwables = Throwables.instance();

    public AbstractThrowableAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    protected SELF hasBeenThrown() {
        if (this.actual == null) {
            throw Failures.instance().failure((AssertionInfo)this.info, new BasicErrorMessageFactory("%nExpecting code to raise a throwable.", new Object[0]));
        }
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasMessage(String message) {
        this.throwables.assertHasMessage(this.info, (Throwable)this.actual, message);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasMessage(String message, Object ... parameters) {
        return this.hasMessage(String.format(message, parameters));
    }

    public SELF hasCause(Throwable cause) {
        this.throwables.assertHasCause(this.info, (Throwable)this.actual, cause);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasCauseReference(Throwable expected) {
        this.throwables.assertHasCauseReference(this.info, (Throwable)this.actual, expected);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasNoCause() {
        this.throwables.assertHasNoCause(this.info, (Throwable)this.actual);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasMessageStartingWith(String description) {
        this.throwables.assertHasMessageStartingWith(this.info, (Throwable)this.actual, description);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasMessageStartingWith(String description, Object ... parameters) {
        this.throwables.assertHasMessageStartingWith(this.info, (Throwable)this.actual, String.format(description, parameters));
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasMessageContaining(String description) {
        this.throwables.assertHasMessageContaining(this.info, (Throwable)this.actual, description);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasMessageContaining(String description, Object ... parameters) {
        this.throwables.assertHasMessageContaining(this.info, (Throwable)this.actual, String.format(description, parameters));
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasMessageContainingAll(CharSequence ... values) {
        this.throwables.assertHasMessageContainingAll(this.info, (Throwable)this.actual, values);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasMessageNotContaining(String content) {
        this.throwables.assertHasMessageNotContaining(this.info, (Throwable)this.actual, content);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasMessageNotContainingAny(CharSequence ... values) {
        this.throwables.assertHasMessageNotContainingAny(this.info, (Throwable)this.actual, values);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasStackTraceContaining(String description) {
        this.throwables.assertHasStackTraceContaining(this.info, (Throwable)this.actual, description);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasStackTraceContaining(String description, Object ... parameters) {
        this.throwables.assertHasStackTraceContaining(this.info, (Throwable)this.actual, String.format(description, parameters));
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasMessageMatching(String regex) {
        this.throwables.assertHasMessageMatching(this.info, (Throwable)this.actual, regex);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasMessageFindingMatch(String regex) {
        this.throwables.assertHasMessageFindingMatch(this.info, (Throwable)this.actual, regex);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasMessageEndingWith(String description) {
        this.throwables.assertHasMessageEndingWith(this.info, (Throwable)this.actual, description);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasMessageEndingWith(String description, Object ... parameters) {
        this.throwables.assertHasMessageEndingWith(this.info, (Throwable)this.actual, String.format(description, parameters));
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasCauseInstanceOf(Class<? extends Throwable> type) {
        this.throwables.assertHasCauseInstanceOf(this.info, (Throwable)this.actual, type);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasCauseExactlyInstanceOf(Class<? extends Throwable> type) {
        this.throwables.assertHasCauseExactlyInstanceOf(this.info, (Throwable)this.actual, type);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasRootCause(Throwable cause) {
        this.throwables.assertHasRootCause(this.info, (Throwable)this.actual, cause);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasRootCauseInstanceOf(Class<? extends Throwable> type) {
        this.throwables.assertHasRootCauseInstanceOf(this.info, (Throwable)this.actual, type);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasRootCauseExactlyInstanceOf(Class<? extends Throwable> type) {
        this.throwables.assertHasRootCauseExactlyInstanceOf(this.info, (Throwable)this.actual, type);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasRootCauseMessage(String message) {
        this.throwables.assertHasRootCauseMessage(this.info, (Throwable)this.actual, message);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasRootCauseMessage(String message, Object ... parameters) {
        return this.hasRootCauseMessage(String.format(message, parameters));
    }

    public SELF hasNoSuppressedExceptions() {
        this.throwables.assertHasNoSuppressedExceptions(this.info, (Throwable)this.actual);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasSuppressedException(Throwable suppressedException) {
        this.throwables.assertHasSuppressedException(this.info, (Throwable)this.actual, suppressedException);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public void doesNotThrowAnyException() {
        if (this.actual != null) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldNotHaveThrown.shouldNotHaveThrown((Throwable)this.actual));
        }
    }
}

