;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-opt %s -all -o %t.text.wast -g -S
;; RUN: wasm-as %s -all -g -o %t.wasm
;; RUN: wasm-dis %t.wasm -all -o %t.bin.wast
;; RUN: wasm-as %s -all -o %t.nodebug.wasm
;; RUN: wasm-dis %t.nodebug.wasm -all -o %t.bin.nodebug.wast
;; RUN: cat %t.text.wast | filecheck %s --check-prefix=CHECK-TEXT
;; RUN: cat %t.bin.wast | filecheck %s --check-prefix=CHECK-BIN
;; RUN: cat %t.bin.nodebug.wast | filecheck %s --check-prefix=CHECK-BIN-NODEBUG

(module
  (memory 1 1 shared)

  ;; CHECK-TEXT:      (type $0 (func))

  ;; CHECK-TEXT:      (memory $0 1 1 shared)

  ;; CHECK-TEXT:      (func $test (type $0)
  ;; CHECK-TEXT-NEXT:  (i32.load
  ;; CHECK-TEXT-NEXT:   (unreachable)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (f32.store
  ;; CHECK-TEXT-NEXT:   (unreachable)
  ;; CHECK-TEXT-NEXT:   (f32.const 0)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (i32.atomic.rmw.add
  ;; CHECK-TEXT-NEXT:   (unreachable)
  ;; CHECK-TEXT-NEXT:   (i64.const 0)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (i32.atomic.rmw.cmpxchg
  ;; CHECK-TEXT-NEXT:   (unreachable)
  ;; CHECK-TEXT-NEXT:   (i64.const 0)
  ;; CHECK-TEXT-NEXT:   (i64.const 1)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (memory.atomic.wait64
  ;; CHECK-TEXT-NEXT:   (unreachable)
  ;; CHECK-TEXT-NEXT:   (i64.const 0)
  ;; CHECK-TEXT-NEXT:   (i64.const 0)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (type $0 (func))

  ;; CHECK-BIN:      (memory $0 1 1 shared)

  ;; CHECK-BIN:      (func $test (type $0)
  ;; CHECK-BIN-NEXT:  (unreachable)
  ;; CHECK-BIN-NEXT: )
  (func $test
    (f32.load (unreachable))

    (f32.store
      (unreachable)
      (f32.const 0)
    )

    (i64.atomic.rmw.add
      (unreachable)
      (i64.const 0)
    )

    (i64.atomic.rmw.cmpxchg
      (unreachable)
      (i64.const 0)
      (i64.const 1)
    )

    (memory.atomic.wait64
      (unreachable)
      (i64.const 0)
      (i64.const 0)
    )
  )
)
;; CHECK-BIN-NODEBUG:      (type $0 (func))

;; CHECK-BIN-NODEBUG:      (memory $0 1 1 shared)

;; CHECK-BIN-NODEBUG:      (func $0 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (unreachable)
;; CHECK-BIN-NODEBUG-NEXT: )
