/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
 * @file diagnostics/basic_exceptions/violated_invariance.hpp
 *
 * @brief The exception to be used if a code invariance is does not hold.
 *
 * @author Christian Schallhart
 *
 * @version $Id: violated_invariance.hpp 296 2007-11-27 00:21:41Z tautschn $
 */

#ifndef DIAGNOSTICS__BASIC_EXCEPTIONS__VIOLATED_INVARIANCE_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__BASIC_EXCEPTIONS__VIOLATED_INVARIANCE_HPP__INCLUDE_GUARD

#include <diagnostics/basic_exceptions/low_level_exception.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;

/**
 * @class Violated_Invariance 
 *
 * @brief The exception to be used if a code invariance is does not hold. Please
 * note that Violated_Invariance is a @ref Low_Level_Exception -- and
 * thus its use is restricted.
 *
 * @nosubgrouping
 */
class Violated_Invariance
    : public Low_Level_Exception
{
    typedef Violated_Invariance Self;
    typedef Low_Level_Exception Super;
public:
    virtual ~Violated_Invariance() DIAGNOSTICS_EXCEPTIONS_THROW_DECL;
    explicit Violated_Invariance(::std::string const & what);
    virtual char const * name() const;
    Violated_Invariance(Self const & other);
};

DIAGNOSTICS_NAMESPACE_END;

#endif /* DIAGNOSTICS__BASIC_EXCEPTIONS__VIOLATED_INVARIANCE_HPP__INCLUDE_GUARD */
