// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id: MakeData.cpp,v 1.7 2006/07/20 02:30:55 vlg Exp $
//------------------------------------------------------------------------------
//                            MakeData.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2003 by Vladislav Grinchenko 
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Fri Jul  4 13:55:47 2003
//
//------------------------------------------------------------------------------

static const char help_msg[]=
"                                                                            \n"
" NAME:                                                                      \n"
"                                                                            \n"
"   make-data                                                                \n"
"                                                                            \n"
" DESCRIPTION:                                                               \n"
"                                                                            \n"
"   Generate ASCII test files for testing ASSA log server.                   \n"
"   An optional input file is repetitevly copied into the output file        \n"
"   until the desired output file size is reached. If an input file          \n"
"   option is omitted, MakeData.cpp is used instead.                         \n"
"                                                                            \n"
" USAGE:                                                                     \n"
"                                                                            \n"
"   shell>  make-data [OPTIONS] -o <name> -n <size>                          \n"
"                                                                            \n"
" EXAMPLE:                                                                   \n"
"                                                                            \n"
"   shell>  make-data --output-file 1Mb -n 1                                 \n"
"                                                                            \n"
"   Create ASCII file of 1 megabyte long with name 1Mb by repetetively       \n"
"   copying MakeData.cpp.                                                    \n"
"                                                                            \n"
" OPTIONS:                                                                   \n"
"                                                                            \n"
" -o, --output-file NAME  - Name of the output data file                     \n"
" -i, --input-file NAME   - Name of the input data file (optional)           \n"
" -n, --size NUM          - Output file size (in megabytes)                  \n"
"                                                                            \n"
" -D, --log-file NAME     - Write debug to NAME file                         \n"
" -d, --log-stdout        - Write debug to standard output                   \n"
" -z, --log-size NUM      - Maximum size debug file can reach (dfl: is 10Mb) \n"
"                                                                            \n"
" -m, --mask MASK         - Mask (default: ALL = 0x7fffffff)                 \n"
" -h, --help              - Print this messag                                \n"
" -v, --version           - Print version number                            \n";
//------------------------------------------------------------------------------

#include <iostream>
#include <fstream>
#include <assa/Assure.h>

#ifdef HAVE_CONFIG_H
#    include "config.h"
#endif
#include <string>
using std::string;

#include <assa/GenServer.h>
#include <assa/Singleton.h>
#include <assa/TimeVal.h>

class MakeData :
    public ASSA::GenServer,
    public ASSA::Singleton<MakeData>
{
public:
    MakeData ();

    virtual void init_service ();
    virtual void process_events ();

private:
	std::string     m_ofname;
	int             m_ofsize;	// In Megabytes
	std::string     m_ifname;
};

/* Useful definitions */

#define MAKEDATA  MakeData::get_instance()
#define REACTOR MAKEDATA->get_reactor()

// Static declarations mandated by Singleton class
ASSA_DECL_SINGLETON(MakeData);

MakeData::
MakeData () : 
	m_ofname ("1Mb"),
	m_ofsize (1),
	m_ifname ("MakeData.cpp")
{
    // ---Configuration---
    rm_opt ('f', "config-file"  );
    rm_opt ('n', "instance"     );
    rm_opt ('p', "port"         );

    // ---Process bookkeeping---
    rm_opt ('b', "daemon"       );
    rm_opt ('l', "pidfile"      );
    rm_opt ('L', "ommit-pidfile");

	add_opt ('o', "output-file", &m_ofname);
	add_opt ('i', "input-file", &m_ifname);
	add_opt ('n', "size", &m_ofsize);

    /*---
     * By defauil disable all debugging
     *---*/
    // m_debug_mask = ASSA::APP | ASSA::ASSAERR;
    m_mask = 0x0;
}

void
MakeData::
init_service ()
{
    trace("MakeData::init_service");

	if (m_ofname.size () == 0) {
		std::cerr << "Missing parameter: --output-name NAME\n";
		set_exit_value (1);
		stop_service ();
	}
	if (m_ifname.size () == 0) {
		std::cerr << "Missing parameter: --input-name NAME\n";
		set_exit_value (1);
		stop_service ();
	}
}

void
MakeData::
process_events ()
{
    trace("MakeData::process_events");

	register char c;
	register unsigned long so_far = 0;
	unsigned long total_sz = m_ofsize * 1024 * 1024; // In Megabytes

	if (service_is_active ())
	{
		std::ofstream ofile (m_ofname.c_str (), 
							 std::ios::out | std::ios::trunc);
		if (!ofile) {
			DL((ASSA::APP,"Failed to open \"%s\"\n", m_ofname.c_str ()));
			goto done;
		}

		std::ifstream ifile (m_ifname.c_str (), std::ios::in);

		if (!ifile) {
			DL((ASSA::APP,"Failed to open \"%s\"\n", m_ifname.c_str ()));
			goto done;
		}

	rewind:
		while (ifile.get (c)) {
			ofile.put (c);
			if (++so_far >= total_sz) {
				ofile.put ('\n');
				ofile.close ();
				ifile.close ();
				goto done;
			}
		}
		ifile.clear ();			// clear eofbit and failbit set due to EOF
		ifile.seekg (0, std::ios::beg);
		goto rewind;
    }

 done:	
    m_reactor.stopReactor ();
    DL((ASSA::APP,"Service stopped!\n"));
}

int
main (int argc, char* argv[])
{
    static const char release[] = "1.0";
    int patch_level = 0;

    MAKEDATA->set_version (release, patch_level);
    MAKEDATA->set_author  ("Vladislav Grinchenko");
    MAKEDATA->set_flags   (ASSA::GenServer::RMLOG);

    MAKEDATA->init (&argc, argv, help_msg);
 
    MAKEDATA->init_service ();
    MAKEDATA->process_events ();

    return MAKEDATA->get_exit_value ();
}

