# Security Policy

## Supported Versions

We support the latest `1.x` release series. Versions older than `1.0` no longer receive security fixes.

## Reporting a Vulnerability

We ask that all security issues be reported privately so that we have a reasonable chance to understand and address the problem before it is made public. Please **do not open public GitHub issues, discussions, or pull requests** for suspected vulnerabilities.

Submit your report through GitHub's [private vulnerability reporting](https://docs.github.com/en/code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability) tool for this repository. Reports sent through other channels may be missed.

When reporting, please include as much of the following information as you can:

* A clear description of the problem and its potential impact.
* Steps to reproduce the issue, preferably with a minimal XML payload or script.
* Any known workarounds or mitigations.
* Your preferred timeline for coordinated disclosure.

We may reach out to you via the GitHub vulnerability report thread for additional details or to coordinate testing a fix. If you need encrypted communication, please mention that in the report so we can explore options together.

## Coordinated Disclosure Expectations

This project currently has a single unpaid volunteer maintainer who may be offline for multiple weeks at a time. Because of this, please allow **up to 30 calendar days** for an initial response on your GitHub private vulnerability report before considering alternate disclosure paths. If you have not heard back within that window, feel free to update the same report to nudge us.

Once we have acknowledged the report, we ask for **at least 90 days** to investigate, implement, and release a fix before any public disclosure, unless we mutually agree on a different timeline. Complex issues, especially those requiring upstream changes or ecosystem coordination, may take longer. During that time we will keep you updated as we make progress. If we determine that a coordinated public disclosure is necessary before a fix is ready, we will work with you on messaging and timing.

## Recognition

We are grateful to the security community for helping keep `xmltodict` safe. With your permission, we will credit you in the release notes or changelog when a fix is published.

## Thank You

Responsible disclosure helps protect all users of `xmltodict`. Your patience and willingness to coordinate—especially given the maintainer's volunteer capacity—are essential to making that possible. Thank you for taking the time to report issues responsibly.
