/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import com.google.caliper.Benchmark;
import com.google.caliper.ConfigurationException;
import com.google.caliper.Param;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.TreeMap;

abstract class Parameter<T> {
    private final Field field;

    private Parameter(Field field) {
        this.field = field;
    }

    public static Map<String, Parameter<?>> forClass(Class<? extends Benchmark> suiteClass) {
        TreeMap parameters = new TreeMap();
        for (Field field : suiteClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Param.class)) continue;
            field.setAccessible(true);
            Parameter<?> parameter = Parameter.forField(suiteClass, field);
            parameters.put(parameter.getName(), parameter);
        }
        return parameters;
    }

    @VisibleForTesting
    static Parameter<?> forField(Class<? extends Benchmark> suiteClass, final Field field) {
        final Object[] defaults = field.getAnnotation(Param.class).value();
        if (defaults.length > 0) {
            return new Parameter<Object>(field){

                @Override
                public Iterable<Object> values() throws Exception {
                    return Arrays.asList(defaults);
                }
            };
        }
        Parameter<Object> result = null;
        Object returnType = null;
        AccessibleObject member = null;
        try {
            final Method valuesMethod = suiteClass.getDeclaredMethod(field.getName() + "Values", new Class[0]);
            if (!Modifier.isStatic(valuesMethod.getModifiers())) {
                throw new ConfigurationException("Values method must be static " + member);
            }
            valuesMethod.setAccessible(true);
            member = valuesMethod;
            returnType = valuesMethod.getGenericReturnType();
            result = new Parameter<Object>(field){

                @Override
                public Iterable<Object> values() throws Exception {
                    return (Iterable)valuesMethod.invoke(null, new Object[0]);
                }
            };
        }
        catch (NoSuchMethodException ignored) {
            // empty catch block
        }
        try {
            final Field valuesField = suiteClass.getDeclaredField(field.getName() + "Values");
            if (!Modifier.isStatic(valuesField.getModifiers())) {
                throw new ConfigurationException("Values field must be static " + member);
            }
            valuesField.setAccessible(true);
            member = valuesField;
            if (result != null) {
                throw new ConfigurationException("Two values members defined for " + field);
            }
            returnType = valuesField.getGenericType();
            result = new Parameter<Object>(field){

                @Override
                public Iterable<Object> values() throws Exception {
                    return (Iterable)valuesField.get(null);
                }
            };
        }
        catch (NoSuchFieldException ignored) {
            // empty catch block
        }
        if (member == null && field.getType().isEnum()) {
            returnType = Collection.class;
            result = new Parameter<Object>(field){

                @Override
                public Iterable<Object> values() throws Exception {
                    EnumSet<?> set = EnumSet.allOf(field.getType());
                    return Collections.unmodifiableSet(set);
                }
            };
        }
        if (member == null && field.getType() == Boolean.TYPE) {
            returnType = Collection.class;
            result = new Parameter<Object>(field){

                @Override
                public Iterable<Object> values() throws Exception {
                    return Arrays.asList(Boolean.TRUE, Boolean.FALSE);
                }
            };
        }
        if (result == null) {
            return new Parameter<Object>(field){

                @Override
                public Iterable<Object> values() {
                    return Collections.emptySet();
                }
            };
        }
        if (!Parameter.isValidReturnType(returnType)) {
            throw new ConfigurationException("Invalid return type " + returnType + " for values member " + member + "; must be Collection");
        }
        return result;
    }

    private static boolean isValidReturnType(Type type) {
        if (type instanceof Class) {
            return Parameter.isIterableClass(type);
        }
        if (type instanceof ParameterizedType) {
            return Parameter.isIterableClass(((ParameterizedType)type).getRawType());
        }
        return false;
    }

    private static boolean isIterableClass(Type returnClass) {
        return Iterable.class.isAssignableFrom((Class)returnClass);
    }

    public void set(Benchmark suite, Object value) throws Exception {
        this.field.set(suite, value);
    }

    public abstract Iterable<T> values() throws Exception;

    public Type getType() {
        return this.field.getGenericType();
    }

    String getName() {
        return this.field.getName();
    }
}

