# Release history

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](http://keepachangelog.com/en/1.0.0/)
and this project adheres to [Semantic Versioning](http://semver.org/spec/v2.0.0.html).

<details>
  <summary><strong>Guiding Principles</strong></summary>

- Changelogs are for humans, not machines.
- There should be an entry for every single version.
- The same types of changes should be grouped.
- Versions and sections should be linkable.
- The latest version comes first.
- The release date of each versions is displayed.
- Mention whether you follow Semantic Versioning.

</details>

<details>
  <summary><strong>Types of changes</strong></summary>

Changelog entries are classified using the following labels _(from [keep-a-changelog](http://keepachangelog.com/)_):

- `Added` for new features.
- `Changed` for changes in existing functionality.
- `Deprecated` for soon-to-be removed features.
- `Removed` for now removed features.
- `Fixed` for any bug fixes.
- `Security` in case of vulnerabilities.

</details>

## [6.0.0] - 2018-08-14

- Refactor to use faster scanner

## [5.0.1] - 2018-01-08

- update engine versions

## [5.0.0] - 2018-01-08

- tweak quotes handling
- refactor to use snapdragon-lexer
- Merge pull request #5 from jonschlinkert/refactor

## [4.0.0] - 2017-11-22

- allow options.quotes to be an object
- Merge pull request #4 from jonschlinkert/quotes-object

## [3.1.0] - 2017-11-19

- support `keepEscaping` as a function
- run `lint-deps` to upgrade deps

## [3.0.2] - 2017-06-21

- fix examples

## [3.0.1] - 2017-06-15

- fix examples
- remove unnecessary brackets

## [3.0.0] - 2017-06-15

- support brackets
- support nested brackets
- update release history, run verb

## [2.1.1] - 2017-05-30

- call custom function on escaped tokens

## [2.1.0] - 2017-04-27

- support backticks
- update docs

## [2.0.0] - 2017-04-11

- example callback
- adds support for a sync callback
- update docs, run verb

## [1.0.1] - 2017-04-11

- fix error message for unclosed quote
- allow disabling strict closing of quotes
- add tests for errors and strict option
- Merge pull request #2 from jonschlinkert/strict
- add documentation on options.strict

## [1.0.0] - 2017-02-21

- refactor
- update docs, run `verb`

## [0.1.1] - 2015-08-27

- first commit
- only use 1 nonchar instead of entire array
- Merge pull request #1 from doowb/master

[5.0.1]: https://github.com/jonschlinkert/split-string/compare/5.0.0...5.0.1
[5.0.0]: https://github.com/jonschlinkert/split-string/compare/4.0.0...5.0.0
[4.0.0]: https://github.com/jonschlinkert/split-string/compare/3.1.0...4.0.0
[3.1.0]: https://github.com/jonschlinkert/split-string/compare/3.0.2...3.1.0
[3.0.2]: https://github.com/jonschlinkert/split-string/compare/3.0.1...3.0.2
[3.0.1]: https://github.com/jonschlinkert/split-string/compare/3.0.0...3.0.1
[3.0.0]: https://github.com/jonschlinkert/split-string/compare/2.1.1...3.0.0
[2.1.1]: https://github.com/jonschlinkert/split-string/compare/2.1.0...2.1.1
[2.1.0]: https://github.com/jonschlinkert/split-string/compare/2.0.0...2.1.0
[2.0.0]: https://github.com/jonschlinkert/split-string/compare/1.0.1...2.0.0
[1.0.1]: https://github.com/jonschlinkert/split-string/compare/1.0.0...1.0.1
[1.0.0]: https://github.com/jonschlinkert/split-string/compare/0.1.1...1.0.0

[Unreleased]: https://github.com/jonschlinkert/split-string/compare/0.1.1...HEAD
[keep-a-changelog]: https://github.com/olivierlacan/keep-a-changelog

