
# -*- coding: utf-8 -*-
"""
DO NOT EDIT THIS FILE!
It is automatically generated from opcfoundation.org schemas.
"""

from opcua import ua
from opcua.ua import NodeId, QualifiedName, NumericNodeId, StringNodeId, GuidNodeId
from opcua.ua import NodeClass, LocalizedText


def create_standard_address_space_Part4(server):
  
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(18, 0)
    node.BrowseName = QualifiedName('ExpandedNodeId', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(24, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("Describes a value that is an absolute identifier for a node.")
    attrs.DisplayName = LocalizedText("ExpandedNodeId")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(18, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(24, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(19, 0)
    node.BrowseName = QualifiedName('StatusCode', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(24, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("Describes a value that is a code representing the outcome of an operation by a Server.")
    attrs.DisplayName = LocalizedText("StatusCode")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(19, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(24, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(23, 0)
    node.BrowseName = QualifiedName('DataValue', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(24, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("Describes a value that is a structure containing a value, a status code and timestamps.")
    attrs.DisplayName = LocalizedText("DataValue")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(23, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(24, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(25, 0)
    node.BrowseName = QualifiedName('DiagnosticInfo', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(24, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("Describes a value that is a structure containing diagnostics associated with a StatusCode.")
    attrs.DisplayName = LocalizedText("DiagnosticInfo")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(25, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(24, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(288, 0)
    node.BrowseName = QualifiedName('IntegerId', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(7, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("A numeric identifier for an object.")
    attrs.DisplayName = LocalizedText("IntegerId")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(288, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(307, 0)
    node.BrowseName = QualifiedName('ApplicationType', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(29, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("The types of applications.")
    attrs.DisplayName = LocalizedText("ApplicationType")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(46, 0)
    ref.SourceNodeId = NumericNodeId(307, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7597, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(307, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(29, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(7597, 0)
    node.BrowseName = QualifiedName('EnumStrings', 0)
    node.NodeClass = NodeClass.Variable
    node.ParentNodeId = NumericNodeId(307, 0)
    node.ReferenceTypeId = NumericNodeId(46, 0)
    node.TypeDefinition = NumericNodeId(68, 0)
    attrs = ua.VariableAttributes()
    attrs.DisplayName = LocalizedText("EnumStrings")
    attrs.DataType = ua.NodeId(ua.ObjectIds.LocalizedText)
    attrs.Value = [LocalizedText('Server'),LocalizedText('Client'),LocalizedText('ClientAndServer'),LocalizedText('DiscoveryServer')]
    attrs.ValueRank = 1
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(7597, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(68, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(37, 0)
    ref.SourceNodeId = NumericNodeId(7597, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(78, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(46, 0)
    ref.SourceNodeId = NumericNodeId(7597, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(307, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(308, 0)
    node.BrowseName = QualifiedName('ApplicationDescription', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("Describes an application and how to find it.")
    attrs.DisplayName = LocalizedText("ApplicationDescription")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(308, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(20998, 0)
    node.BrowseName = QualifiedName('VersionTime', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(7, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.DisplayName = LocalizedText("VersionTime")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(20998, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(12189, 0)
    node.BrowseName = QualifiedName('ServerOnNetwork', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.DisplayName = LocalizedText("ServerOnNetwork")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(12189, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(311, 0)
    node.BrowseName = QualifiedName('ApplicationInstanceCertificate', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(15, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("A certificate for an instance of an application.")
    attrs.DisplayName = LocalizedText("ApplicationInstanceCertificate")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(311, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(15, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(302, 0)
    node.BrowseName = QualifiedName('MessageSecurityMode', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(29, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("The type of security to use on a message.")
    attrs.DisplayName = LocalizedText("MessageSecurityMode")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(46, 0)
    ref.SourceNodeId = NumericNodeId(302, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7595, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(302, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(29, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(7595, 0)
    node.BrowseName = QualifiedName('EnumStrings', 0)
    node.NodeClass = NodeClass.Variable
    node.ParentNodeId = NumericNodeId(302, 0)
    node.ReferenceTypeId = NumericNodeId(46, 0)
    node.TypeDefinition = NumericNodeId(68, 0)
    attrs = ua.VariableAttributes()
    attrs.DisplayName = LocalizedText("EnumStrings")
    attrs.DataType = ua.NodeId(ua.ObjectIds.LocalizedText)
    attrs.Value = [LocalizedText('Invalid'),LocalizedText('None'),LocalizedText('Sign'),LocalizedText('SignAndEncrypt')]
    attrs.ValueRank = 1
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(7595, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(68, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(37, 0)
    ref.SourceNodeId = NumericNodeId(7595, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(78, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(46, 0)
    ref.SourceNodeId = NumericNodeId(7595, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(302, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(303, 0)
    node.BrowseName = QualifiedName('UserTokenType', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(29, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("The possible user token types.")
    attrs.DisplayName = LocalizedText("UserTokenType")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(46, 0)
    ref.SourceNodeId = NumericNodeId(303, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7596, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(303, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(29, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(7596, 0)
    node.BrowseName = QualifiedName('EnumStrings', 0)
    node.NodeClass = NodeClass.Variable
    node.ParentNodeId = NumericNodeId(303, 0)
    node.ReferenceTypeId = NumericNodeId(46, 0)
    node.TypeDefinition = NumericNodeId(68, 0)
    attrs = ua.VariableAttributes()
    attrs.DisplayName = LocalizedText("EnumStrings")
    attrs.DataType = ua.NodeId(ua.ObjectIds.LocalizedText)
    attrs.Value = [LocalizedText('Anonymous'),LocalizedText('UserName'),LocalizedText('Certificate'),LocalizedText('IssuedToken')]
    attrs.ValueRank = 1
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(7596, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(68, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(37, 0)
    ref.SourceNodeId = NumericNodeId(7596, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(78, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(46, 0)
    ref.SourceNodeId = NumericNodeId(7596, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(303, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(304, 0)
    node.BrowseName = QualifiedName('UserTokenPolicy', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("Describes a user token that can be used with a server.")
    attrs.DisplayName = LocalizedText("UserTokenPolicy")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(304, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(312, 0)
    node.BrowseName = QualifiedName('EndpointDescription', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("The description of a endpoint that can be used to access a server.")
    attrs.DisplayName = LocalizedText("EndpointDescription")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(312, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(432, 0)
    node.BrowseName = QualifiedName('RegisteredServer', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("The information required to register a server with a discovery server.")
    attrs.DisplayName = LocalizedText("RegisteredServer")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(432, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(12890, 0)
    node.BrowseName = QualifiedName('DiscoveryConfiguration', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("A base type for discovery configuration information.")
    attrs.DisplayName = LocalizedText("DiscoveryConfiguration")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(12890, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(12891, 0)
    node.BrowseName = QualifiedName('MdnsDiscoveryConfiguration', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(12890, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("The discovery information needed for mDNS registration.")
    attrs.DisplayName = LocalizedText("MdnsDiscoveryConfiguration")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(12891, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12890, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(315, 0)
    node.BrowseName = QualifiedName('SecurityTokenRequestType', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(29, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("Indicates whether a token if being created or renewed.")
    attrs.DisplayName = LocalizedText("SecurityTokenRequestType")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(46, 0)
    ref.SourceNodeId = NumericNodeId(315, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7598, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(315, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(29, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(7598, 0)
    node.BrowseName = QualifiedName('EnumStrings', 0)
    node.NodeClass = NodeClass.Variable
    node.ParentNodeId = NumericNodeId(315, 0)
    node.ReferenceTypeId = NumericNodeId(46, 0)
    node.TypeDefinition = NumericNodeId(68, 0)
    attrs = ua.VariableAttributes()
    attrs.DisplayName = LocalizedText("EnumStrings")
    attrs.DataType = ua.NodeId(ua.ObjectIds.LocalizedText)
    attrs.Value = [LocalizedText('Issue'),LocalizedText('Renew')]
    attrs.ValueRank = 1
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(7598, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(68, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(37, 0)
    ref.SourceNodeId = NumericNodeId(7598, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(78, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(46, 0)
    ref.SourceNodeId = NumericNodeId(7598, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(315, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(344, 0)
    node.BrowseName = QualifiedName('SignedSoftwareCertificate', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("A software certificate with a digital signature.")
    attrs.DisplayName = LocalizedText("SignedSoftwareCertificate")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(344, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(388, 0)
    node.BrowseName = QualifiedName('SessionAuthenticationToken', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(17, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("A unique identifier for a session used to authenticate requests.")
    attrs.DisplayName = LocalizedText("SessionAuthenticationToken")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(388, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(17, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(316, 0)
    node.BrowseName = QualifiedName('UserIdentityToken', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("A base type for a user identity token.")
    attrs.DisplayName = LocalizedText("UserIdentityToken")
    attrs.IsAbstract = True
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(316, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(319, 0)
    node.BrowseName = QualifiedName('AnonymousIdentityToken', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(316, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("A token representing an anonymous user.")
    attrs.DisplayName = LocalizedText("AnonymousIdentityToken")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(319, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(316, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(322, 0)
    node.BrowseName = QualifiedName('UserNameIdentityToken', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(316, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("A token representing a user identified by a user name and password.")
    attrs.DisplayName = LocalizedText("UserNameIdentityToken")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(322, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(316, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(325, 0)
    node.BrowseName = QualifiedName('X509IdentityToken', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(316, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("A token representing a user identified by an X509 certificate.")
    attrs.DisplayName = LocalizedText("X509IdentityToken")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(325, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(316, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(938, 0)
    node.BrowseName = QualifiedName('IssuedIdentityToken', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(316, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("A token representing a user identified by a WS-Security XML token.")
    attrs.DisplayName = LocalizedText("IssuedIdentityToken")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(938, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(316, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(348, 0)
    node.BrowseName = QualifiedName('NodeAttributesMask', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(29, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("The bits used to specify default attributes for a new node.")
    attrs.DisplayName = LocalizedText("NodeAttributesMask")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(46, 0)
    ref.SourceNodeId = NumericNodeId(348, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(11881, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(348, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(29, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(11881, 0)
    node.BrowseName = QualifiedName('EnumValues', 0)
    node.NodeClass = NodeClass.Variable
    node.ParentNodeId = NumericNodeId(348, 0)
    node.ReferenceTypeId = NumericNodeId(46, 0)
    node.TypeDefinition = NumericNodeId(68, 0)
    attrs = ua.VariableAttributes()
    attrs.DisplayName = LocalizedText("EnumValues")
    attrs.DataType = NumericNodeId(7594, 0)
    value = []
    extobj = ua.EnumValueType()
    extobj.Value = 0
    extobj.DisplayName.Text = 'None'
    extobj.Description.Text = 'No attribuites provided.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 1
    extobj.DisplayName.Text = 'AccessLevel'
    extobj.Description.Text = 'The access level attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 2
    extobj.DisplayName.Text = 'ArrayDimensions'
    extobj.Description.Text = 'The array dimensions attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 4
    extobj.DisplayName.Text = 'BrowseName'
    extobj.Description.Text = 'The browse name attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 8
    extobj.DisplayName.Text = 'ContainsNoLoops'
    extobj.Description.Text = 'The contains no loops attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 16
    extobj.DisplayName.Text = 'DataType'
    extobj.Description.Text = 'The data type attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 32
    extobj.DisplayName.Text = 'Description'
    extobj.Description.Text = 'The description attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 64
    extobj.DisplayName.Text = 'DisplayName'
    extobj.Description.Text = 'The display name attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 128
    extobj.DisplayName.Text = 'EventNotifier'
    extobj.Description.Text = 'The event notifier attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 256
    extobj.DisplayName.Text = 'Executable'
    extobj.Description.Text = 'The executable attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 512
    extobj.DisplayName.Text = 'Historizing'
    extobj.Description.Text = 'The historizing attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 1024
    extobj.DisplayName.Text = 'InverseName'
    extobj.Description.Text = 'The inverse name attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 2048
    extobj.DisplayName.Text = 'IsAbstract'
    extobj.Description.Text = 'The is abstract attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 4096
    extobj.DisplayName.Text = 'MinimumSamplingInterval'
    extobj.Description.Text = 'The minimum sampling interval attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 8192
    extobj.DisplayName.Text = 'NodeClass'
    extobj.Description.Text = 'The node class attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 16384
    extobj.DisplayName.Text = 'NodeId'
    extobj.Description.Text = 'The node id attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 32768
    extobj.DisplayName.Text = 'Symmetric'
    extobj.Description.Text = 'The symmetric attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 65536
    extobj.DisplayName.Text = 'UserAccessLevel'
    extobj.Description.Text = 'The user access level attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 131072
    extobj.DisplayName.Text = 'UserExecutable'
    extobj.Description.Text = 'The user executable attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 262144
    extobj.DisplayName.Text = 'UserWriteMask'
    extobj.Description.Text = 'The user write mask attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 524288
    extobj.DisplayName.Text = 'ValueRank'
    extobj.Description.Text = 'The value rank attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 1048576
    extobj.DisplayName.Text = 'WriteMask'
    extobj.Description.Text = 'The write mask attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 2097152
    extobj.DisplayName.Text = 'Value'
    extobj.Description.Text = 'The value attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 4194304
    extobj.DisplayName.Text = 'DataTypeDefinition'
    extobj.Description.Text = 'The write mask attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 8388608
    extobj.DisplayName.Text = 'RolePermissions'
    extobj.Description.Text = 'The write mask attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 16777216
    extobj.DisplayName.Text = 'AccessRestrictions'
    extobj.Description.Text = 'The write mask attribute is specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 33554431
    extobj.DisplayName.Text = 'All'
    extobj.Description.Text = 'All attributes are specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 26501220
    extobj.DisplayName.Text = 'BaseNode'
    extobj.Description.Text = 'All base attributes are specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 26501348
    extobj.DisplayName.Text = 'Object'
    extobj.Description.Text = 'All object attributes are specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 26503268
    extobj.DisplayName.Text = 'ObjectType'
    extobj.Description.Text = 'All object type attributes are specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 26571383
    extobj.DisplayName.Text = 'Variable'
    extobj.Description.Text = 'All variable attributes are specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 28600438
    extobj.DisplayName.Text = 'VariableType'
    extobj.Description.Text = 'All variable type attributes are specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 26632548
    extobj.DisplayName.Text = 'Method'
    extobj.Description.Text = 'All method attributes are specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 26537060
    extobj.DisplayName.Text = 'ReferenceType'
    extobj.Description.Text = 'All reference type attributes are specified.'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 26501356
    extobj.DisplayName.Text = 'View'
    extobj.Description.Text = 'All view attributes are specified.'
    value.append(extobj)
    attrs.Value = ua.Variant(value, ua.VariantType.ExtensionObject)
    attrs.ValueRank = 1
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(11881, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(68, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(37, 0)
    ref.SourceNodeId = NumericNodeId(11881, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(78, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(46, 0)
    ref.SourceNodeId = NumericNodeId(11881, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(348, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(376, 0)
    node.BrowseName = QualifiedName('AddNodesItem', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("A request to add a node to the server address space.")
    attrs.DisplayName = LocalizedText("AddNodesItem")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(376, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(379, 0)
    node.BrowseName = QualifiedName('AddReferencesItem', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("A request to add a reference to the server address space.")
    attrs.DisplayName = LocalizedText("AddReferencesItem")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(379, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(382, 0)
    node.BrowseName = QualifiedName('DeleteNodesItem', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("A request to delete a node to the server address space.")
    attrs.DisplayName = LocalizedText("DeleteNodesItem")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(382, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(385, 0)
    node.BrowseName = QualifiedName('DeleteReferencesItem', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("A request to delete a node from the server address space.")
    attrs.DisplayName = LocalizedText("DeleteReferencesItem")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(385, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(347, 0)
    node.BrowseName = QualifiedName('AttributeWriteMask', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(7, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("Define bits used to indicate which attributes are writable.")
    attrs.DisplayName = LocalizedText("AttributeWriteMask")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(46, 0)
    ref.SourceNodeId = NumericNodeId(347, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(15036, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(347, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15036, 0)
    node.BrowseName = QualifiedName('OptionSetValues', 0)
    node.NodeClass = NodeClass.Variable
    node.ParentNodeId = NumericNodeId(347, 0)
    node.ReferenceTypeId = NumericNodeId(46, 0)
    node.TypeDefinition = NumericNodeId(68, 0)
    attrs = ua.VariableAttributes()
    attrs.DisplayName = LocalizedText("OptionSetValues")
    attrs.DataType = ua.NodeId(ua.ObjectIds.LocalizedText)
    attrs.Value = [LocalizedText('AccessLevel'),LocalizedText('ArrayDimensions'),LocalizedText('BrowseName'),LocalizedText('ContainsNoLoops'),LocalizedText('DataType'),LocalizedText('Description'),LocalizedText('DisplayName'),LocalizedText('EventNotifier'),LocalizedText('Executable'),LocalizedText('Historizing'),LocalizedText('InverseName'),LocalizedText('IsAbstract'),LocalizedText('MinimumSamplingInterval'),LocalizedText('NodeClass'),LocalizedText('NodeId'),LocalizedText('Symmetric'),LocalizedText('UserAccessLevel'),LocalizedText('UserExecutable'),LocalizedText('UserWriteMask'),LocalizedText('ValueRank'),LocalizedText('WriteMask'),LocalizedText('ValueForVariableType'),LocalizedText('DataTypeDefinition'),LocalizedText('RolePermissions'),LocalizedText('AccessRestrictions'),LocalizedText('AccessLevelEx')]
    attrs.ValueRank = 1
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15036, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(68, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(37, 0)
    ref.SourceNodeId = NumericNodeId(15036, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(78, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(46, 0)
    ref.SourceNodeId = NumericNodeId(15036, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(347, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(521, 0)
    node.BrowseName = QualifiedName('ContinuationPoint', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(15, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("An identifier for a suspended query or browse operation.")
    attrs.DisplayName = LocalizedText("ContinuationPoint")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(521, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(15, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(537, 0)
    node.BrowseName = QualifiedName('RelativePathElement', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("An element in a relative path.")
    attrs.DisplayName = LocalizedText("RelativePathElement")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(537, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(540, 0)
    node.BrowseName = QualifiedName('RelativePath', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("A relative path constructed from reference types and browse names.")
    attrs.DisplayName = LocalizedText("RelativePath")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(540, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(289, 0)
    node.BrowseName = QualifiedName('Counter', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(7, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("A monotonically increasing value.")
    attrs.DisplayName = LocalizedText("Counter")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(289, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(291, 0)
    node.BrowseName = QualifiedName('NumericRange', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(12, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("Specifies a range of array indexes.")
    attrs.DisplayName = LocalizedText("NumericRange")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(291, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(292, 0)
    node.BrowseName = QualifiedName('Time', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(12, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("A time value specified as HH:MM:SS.SSS.")
    attrs.DisplayName = LocalizedText("Time")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(292, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(293, 0)
    node.BrowseName = QualifiedName('Date', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(13, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.Description = LocalizedText("A date value.")
    attrs.DisplayName = LocalizedText("Date")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(293, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(13, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(331, 0)
    node.BrowseName = QualifiedName('EndpointConfiguration', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.DisplayName = LocalizedText("EndpointConfiguration")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(331, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(576, 0)
    node.BrowseName = QualifiedName('FilterOperator', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(29, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.DisplayName = LocalizedText("FilterOperator")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(46, 0)
    ref.SourceNodeId = NumericNodeId(576, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7605, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(576, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(29, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(7605, 0)
    node.BrowseName = QualifiedName('EnumStrings', 0)
    node.NodeClass = NodeClass.Variable
    node.ParentNodeId = NumericNodeId(576, 0)
    node.ReferenceTypeId = NumericNodeId(46, 0)
    node.TypeDefinition = NumericNodeId(68, 0)
    attrs = ua.VariableAttributes()
    attrs.DisplayName = LocalizedText("EnumStrings")
    attrs.DataType = ua.NodeId(ua.ObjectIds.LocalizedText)
    attrs.Value = [LocalizedText('Equals'),LocalizedText('IsNull'),LocalizedText('GreaterThan'),LocalizedText('LessThan'),LocalizedText('GreaterThanOrEqual'),LocalizedText('LessThanOrEqual'),LocalizedText('Like'),LocalizedText('Not'),LocalizedText('Between'),LocalizedText('InList'),LocalizedText('And'),LocalizedText('Or'),LocalizedText('Cast'),LocalizedText('InView'),LocalizedText('OfType'),LocalizedText('RelatedTo'),LocalizedText('BitwiseAnd'),LocalizedText('BitwiseOr')]
    attrs.ValueRank = 1
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(7605, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(68, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(37, 0)
    ref.SourceNodeId = NumericNodeId(7605, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(78, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(46, 0)
    ref.SourceNodeId = NumericNodeId(7605, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(576, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(583, 0)
    node.BrowseName = QualifiedName('ContentFilterElement', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.DisplayName = LocalizedText("ContentFilterElement")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(583, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(586, 0)
    node.BrowseName = QualifiedName('ContentFilter', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.DisplayName = LocalizedText("ContentFilter")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(586, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(589, 0)
    node.BrowseName = QualifiedName('FilterOperand', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.DisplayName = LocalizedText("FilterOperand")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(589, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(592, 0)
    node.BrowseName = QualifiedName('ElementOperand', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(589, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.DisplayName = LocalizedText("ElementOperand")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(592, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(589, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(595, 0)
    node.BrowseName = QualifiedName('LiteralOperand', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(589, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.DisplayName = LocalizedText("LiteralOperand")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(595, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(589, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(598, 0)
    node.BrowseName = QualifiedName('AttributeOperand', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(589, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.DisplayName = LocalizedText("AttributeOperand")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(598, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(589, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(601, 0)
    node.BrowseName = QualifiedName('SimpleAttributeOperand', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(589, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.DisplayName = LocalizedText("SimpleAttributeOperand")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(601, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(589, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(659, 0)
    node.BrowseName = QualifiedName('HistoryEvent', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.DisplayName = LocalizedText("HistoryEvent")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(659, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(11234, 0)
    node.BrowseName = QualifiedName('HistoryUpdateType', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(29, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.DisplayName = LocalizedText("HistoryUpdateType")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(46, 0)
    ref.SourceNodeId = NumericNodeId(11234, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(11884, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(11234, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(29, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(11884, 0)
    node.BrowseName = QualifiedName('EnumValues', 0)
    node.NodeClass = NodeClass.Variable
    node.ParentNodeId = NumericNodeId(11234, 0)
    node.ReferenceTypeId = NumericNodeId(46, 0)
    node.TypeDefinition = NumericNodeId(68, 0)
    attrs = ua.VariableAttributes()
    attrs.DisplayName = LocalizedText("EnumValues")
    attrs.DataType = NumericNodeId(7594, 0)
    value = []
    extobj = ua.EnumValueType()
    extobj.Value = 1
    extobj.DisplayName.Text = 'Insert'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 2
    extobj.DisplayName.Text = 'Replace'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 3
    extobj.DisplayName.Text = 'Update'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 4
    extobj.DisplayName.Text = 'Delete'
    value.append(extobj)
    attrs.Value = ua.Variant(value, ua.VariantType.ExtensionObject)
    attrs.ValueRank = 1
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(11884, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(68, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(37, 0)
    ref.SourceNodeId = NumericNodeId(11884, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(78, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(46, 0)
    ref.SourceNodeId = NumericNodeId(11884, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(11234, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(11293, 0)
    node.BrowseName = QualifiedName('PerformUpdateType', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(29, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.DisplayName = LocalizedText("PerformUpdateType")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(46, 0)
    ref.SourceNodeId = NumericNodeId(11293, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(11885, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(11293, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(29, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(11885, 0)
    node.BrowseName = QualifiedName('EnumValues', 0)
    node.NodeClass = NodeClass.Variable
    node.ParentNodeId = NumericNodeId(11293, 0)
    node.ReferenceTypeId = NumericNodeId(46, 0)
    node.TypeDefinition = NumericNodeId(68, 0)
    attrs = ua.VariableAttributes()
    attrs.DisplayName = LocalizedText("EnumValues")
    attrs.DataType = NumericNodeId(7594, 0)
    value = []
    extobj = ua.EnumValueType()
    extobj.Value = 1
    extobj.DisplayName.Text = 'Insert'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 2
    extobj.DisplayName.Text = 'Replace'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 3
    extobj.DisplayName.Text = 'Update'
    value.append(extobj)
    extobj = ua.EnumValueType()
    extobj.Value = 4
    extobj.DisplayName.Text = 'Remove'
    value.append(extobj)
    attrs.Value = ua.Variant(value, ua.VariantType.ExtensionObject)
    attrs.ValueRank = 1
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(11885, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(68, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(37, 0)
    ref.SourceNodeId = NumericNodeId(11885, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(78, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(46, 0)
    ref.SourceNodeId = NumericNodeId(11885, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(11293, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(719, 0)
    node.BrowseName = QualifiedName('MonitoringFilter', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.DisplayName = LocalizedText("MonitoringFilter")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(719, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(725, 0)
    node.BrowseName = QualifiedName('EventFilter', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(719, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.DisplayName = LocalizedText("EventFilter")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(725, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(719, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(948, 0)
    node.BrowseName = QualifiedName('AggregateConfiguration', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.DisplayName = LocalizedText("AggregateConfiguration")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(948, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(920, 0)
    node.BrowseName = QualifiedName('HistoryEventFieldList', 0)
    node.NodeClass = NodeClass.DataType
    node.ParentNodeId = NumericNodeId(22, 0)
    node.ReferenceTypeId = NumericNodeId(45, 0)
    attrs = ua.DataTypeAttributes()
    attrs.DisplayName = LocalizedText("HistoryEventFieldList")
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(45, 0)
    ref.SourceNodeId = NumericNodeId(920, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(22, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(310, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(308, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(310, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(308, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(310, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7665, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(310, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(12207, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(12189, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(12207, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12189, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(12207, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12213, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(12207, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(306, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(304, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(306, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(304, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(306, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7662, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(306, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(314, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(312, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(314, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(312, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(314, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7668, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(314, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(434, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(432, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(434, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(432, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(434, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7782, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(434, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(12900, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(12890, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(12900, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12890, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(12900, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12902, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(12900, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(12901, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(12891, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(12901, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12891, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(12901, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12905, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(12901, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(346, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(344, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(346, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(344, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(346, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7698, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(346, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(318, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(316, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(318, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(316, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(318, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7671, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(318, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(321, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(319, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(321, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(319, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(321, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7674, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(321, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(324, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(322, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(324, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(322, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(324, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7677, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(324, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(327, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(325, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(327, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(325, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(327, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7680, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(327, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(940, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(938, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(940, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(938, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(940, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7683, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(940, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(378, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(376, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(378, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(376, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(378, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7728, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(378, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(381, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(379, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(381, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(379, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(381, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7731, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(381, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(384, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(382, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(384, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(382, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(384, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7734, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(384, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(387, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(385, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(387, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(385, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(387, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7737, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(387, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(539, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(537, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(539, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(537, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(539, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12718, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(539, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(542, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(540, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(542, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(540, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(542, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12721, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(542, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(333, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(331, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(333, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(331, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(333, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7686, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(333, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(585, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(583, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(585, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(583, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(585, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7929, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(585, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(588, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(586, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(588, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(586, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(588, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7932, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(588, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(591, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(589, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(591, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(589, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(591, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7935, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(591, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(594, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(592, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(594, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(592, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(594, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7938, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(594, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(597, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(595, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(597, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(595, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(597, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7941, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(597, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(600, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(598, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(600, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(598, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(600, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7944, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(600, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(603, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(601, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(603, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(601, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(603, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(7947, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(603, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(661, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(659, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(661, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(659, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(661, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8004, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(661, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(721, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(719, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(721, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(719, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(721, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8067, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(721, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(727, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(725, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(727, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(725, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(727, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8073, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(727, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(950, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(948, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(950, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(948, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(950, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8076, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(950, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(922, 0)
    node.BrowseName = QualifiedName('Default Binary', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(920, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default Binary")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(922, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(920, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(922, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8172, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(922, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(309, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(308, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(309, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(308, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(309, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8300, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(309, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(12195, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(12189, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(12195, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12189, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(12195, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12201, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(12195, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(305, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(304, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(305, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(304, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(305, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8297, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(305, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(313, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(312, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(313, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(312, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(313, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8303, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(313, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(433, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(432, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(433, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(432, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(433, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8417, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(433, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(12892, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(12890, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(12892, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12890, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(12892, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12894, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(12892, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(12893, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(12891, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(12893, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12891, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(12893, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12897, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(12893, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(345, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(344, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(345, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(344, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(345, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8333, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(345, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(317, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(316, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(317, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(316, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(317, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8306, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(317, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(320, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(319, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(320, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(319, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(320, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8309, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(320, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(323, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(322, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(323, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(322, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(323, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8312, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(323, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(326, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(325, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(326, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(325, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(326, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8315, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(326, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(939, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(938, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(939, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(938, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(939, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8318, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(939, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(377, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(376, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(377, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(376, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(377, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8363, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(377, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(380, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(379, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(380, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(379, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(380, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8366, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(380, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(383, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(382, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(383, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(382, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(383, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8369, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(383, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(386, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(385, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(386, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(385, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(386, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8372, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(386, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(538, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(537, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(538, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(537, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(538, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12712, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(538, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(541, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(540, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(541, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(540, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(541, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12715, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(541, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(332, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(331, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(332, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(331, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(332, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8321, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(332, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(584, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(583, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(584, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(583, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(584, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8564, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(584, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(587, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(586, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(587, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(586, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(587, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8567, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(587, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(590, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(589, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(590, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(589, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(590, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8570, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(590, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(593, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(592, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(593, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(592, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(593, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8573, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(593, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(596, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(595, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(596, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(595, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(596, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8576, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(596, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(599, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(598, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(599, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(598, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(599, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8579, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(599, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(602, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(601, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(602, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(601, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(602, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8582, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(602, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(660, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(659, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(660, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(659, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(660, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8639, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(660, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(720, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(719, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(720, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(719, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(720, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8702, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(720, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(726, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(725, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(726, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(725, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(726, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8708, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(726, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(949, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(948, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(949, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(948, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(949, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8711, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(949, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(921, 0)
    node.BrowseName = QualifiedName('Default XML', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(920, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default XML")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(921, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(920, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(39, 0)
    ref.SourceNodeId = NumericNodeId(921, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(8807, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(921, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15087, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(308, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15087, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(308, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15087, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15095, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(12189, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15095, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12189, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15095, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15098, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(304, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15098, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(304, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15098, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15099, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(312, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15099, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(312, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15099, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15102, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(432, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15102, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(432, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15102, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15105, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(12890, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15105, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12890, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15105, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15106, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(12891, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15106, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(12891, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15106, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15136, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(344, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15136, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(344, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15136, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15140, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(316, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15140, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(316, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15140, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15141, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(319, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15141, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(319, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15141, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15142, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(322, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15142, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(322, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15142, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15143, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(325, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15143, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(325, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15143, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15144, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(938, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15144, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(938, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15144, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15165, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(376, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15165, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(376, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15165, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15169, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(379, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15169, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(379, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15169, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15172, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(382, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15172, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(382, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15172, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15175, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(385, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15175, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(385, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15175, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15188, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(537, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15188, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(537, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15188, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15189, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(540, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15189, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(540, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15189, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15199, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(331, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15199, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(331, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15199, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15204, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(583, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15204, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(583, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15204, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15205, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(586, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15205, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(586, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15205, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15206, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(589, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15206, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(589, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15206, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15207, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(592, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15207, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(592, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15207, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15208, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(595, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15208, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(595, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15208, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15209, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(598, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15209, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(598, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15209, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15210, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(601, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15210, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(601, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15210, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15273, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(659, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15273, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(659, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15273, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15293, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(719, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15293, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(719, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15293, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15295, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(725, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15295, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(725, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15295, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15304, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(948, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15304, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(948, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15304, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
   
    node = ua.AddNodesItem()
    node.RequestedNewNodeId = NumericNodeId(15349, 0)
    node.BrowseName = QualifiedName('Default JSON', 0)
    node.NodeClass = NodeClass.Object
    node.ParentNodeId = NumericNodeId(920, 0)
    node.ReferenceTypeId = NumericNodeId(38, 0)
    node.TypeDefinition = NumericNodeId(76, 0)
    attrs = ua.ObjectAttributes()
    attrs.DisplayName = LocalizedText("Default JSON")
    attrs.EventNotifier = 0
    node.NodeAttributes = attrs
    server.add_nodes([node])
    refs = []
    ref = ua.AddReferencesItem()
    ref.IsForward = False
    ref.ReferenceTypeId = NumericNodeId(38, 0)
    ref.SourceNodeId = NumericNodeId(15349, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(920, 0)
    refs.append(ref)
    ref = ua.AddReferencesItem()
    ref.IsForward = True
    ref.ReferenceTypeId = NumericNodeId(40, 0)
    ref.SourceNodeId = NumericNodeId(15349, 0)
    ref.TargetNodeClass = NodeClass.DataType
    ref.TargetNodeId = NumericNodeId(76, 0)
    refs.append(ref)
    server.add_references(refs)
