/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui.annotation;

import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotation;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationStyler;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationStyles;
import org.eclipse.fordiac.ide.gef.figures.FBShape;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class WatchpointAnnotationStyler
implements GraphicalAnnotationStyler {
    public void applyStyles(IFigure figure, GraphicalAnnotation annotation) {
        FBShape fbShape;
        if (figure instanceof FBShape && FigureUtilities.isAncestor((IFigure)(fbShape = (FBShape)figure), (IFigure)fbShape.getTypeLabel())) {
            fbShape.getTypeLabel().setOverlayIcon(this.getOverlayImage(annotation));
        } else {
            Image image = this.getImage(annotation);
            if (image != null) {
                GraphicalAnnotationStyles.setAnnotationImageBorder((IFigure)figure, (Image)image);
            }
        }
    }

    public void removeStyles(IFigure figure, GraphicalAnnotation annotation) {
        FBShape fbShape;
        if (figure instanceof FBShape && FigureUtilities.isAncestor((IFigure)(fbShape = (FBShape)figure), (IFigure)fbShape.getTypeLabel())) {
            fbShape.getTypeLabel().setOverlayIcon(null);
        } else {
            GraphicalAnnotationStyles.removeAnnotationBorders((IFigure)figure);
        }
    }

    public Color getColor(GraphicalAnnotation annotation) {
        return null;
    }

    public Image getImage(GraphicalAnnotation annotation) {
        boolean disabled = WatchpointAnnotationStyler.isDisabled(annotation);
        boolean force = WatchpointAnnotationStyler.isForce(annotation);
        if (force) {
            if (disabled) {
                return DebugUITools.getImage((String)"IMG_OBJS_MODIFICATION_WATCHPOINT_DISABLED");
            }
            return DebugUITools.getImage((String)"IMG_OBJS_MODIFICATION_WATCHPOINT");
        }
        if (disabled) {
            return FordiacImage.ICON_WATCHPOINT_DISABLED.getImage();
        }
        return FordiacImage.ICON_WATCHPOINT.getImage();
    }

    public Image getOverlayImage(GraphicalAnnotation annotation) {
        boolean disabled = WatchpointAnnotationStyler.isDisabled(annotation);
        boolean force = WatchpointAnnotationStyler.isForce(annotation);
        if (force) {
            if (disabled) {
                return FordiacImage.ICON_WATCHPOINT_FORCE_DISABLED_OVERLAY.getImage();
            }
            return FordiacImage.ICON_WATCHPOINT_FORCE_OVERLAY.getImage();
        }
        if (disabled) {
            return FordiacImage.ICON_WATCHPOINT_DISABLED_OVERLAY.getImage();
        }
        return FordiacImage.ICON_WATCHPOINT_OVERLAY.getImage();
    }

    private static boolean isDisabled(GraphicalAnnotation annotation) {
        Boolean enabled;
        Object object = annotation.getAttribute("org.eclipse.debug.core.enabled");
        return object instanceof Boolean && (enabled = (Boolean)object) == false;
    }

    private static boolean isForce(GraphicalAnnotation annotation) {
        Boolean forceEnabled;
        Object object = annotation.getAttribute("org.eclipse.fordiac.ide.deployment.debug.watchpointMarker.forceEnabled");
        return object instanceof Boolean && (forceEnabled = (Boolean)object) != false;
    }
}

