/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui.runtime;

import java.util.stream.Stream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.fordiac.ide.debug.ui.MainLaunchConfigurationTab;
import org.eclipse.fordiac.ide.deployment.debug.ui.Messages;
import org.eclipse.fordiac.ide.deployment.interactors.DeviceManagementInteractorFactory;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.ui.editors.DataTypeTreeSelectionDialog;
import org.eclipse.fordiac.ide.model.ui.nat.DeviceTypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.nat.ResourceTypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.nat.TypeNode;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class RuntimeLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    public static final String ID = "org.eclipse.fordiac.ide.deployment.debug.ui.runtimeTab";
    private Text runtimeText;
    private Combo profileCombo;
    private Text deviceTypeText;
    private Text resourceTypeText;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(comp);
        this.setControl((Control)comp);
        Composite runtimeComponent = this.createRuntimeComponent(comp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)runtimeComponent);
        Composite optionsComponent = this.createOptionsComponent(comp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)optionsComponent);
    }

    protected Composite createRuntimeComponent(Composite parent) {
        Group group = new Group(parent, 2048);
        GridLayoutFactory.swtDefaults().applyTo((Composite)group);
        group.setText(Messages.RuntimeLaunchConfigurationTab_RuntimeGroup);
        Composite comp = new Composite((Composite)group, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(comp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)comp);
        Label locationLabel = new Label(comp, 0);
        locationLabel.setText(Messages.RuntimeLaunchConfigurationTab_LocationLabel);
        GridDataFactory.swtDefaults().applyTo((Control)locationLabel);
        this.runtimeText = new Text(comp, 2048);
        this.runtimeText.setMessage(Messages.RuntimeLaunchConfigurationTab_LocationMessage);
        this.runtimeText.addModifyListener(e -> this.scheduleUpdateJob());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.runtimeText);
        return group;
    }

    protected Composite createOptionsComponent(Composite parent) {
        Group group = new Group(parent, 2048);
        GridLayoutFactory.swtDefaults().applyTo((Composite)group);
        group.setText(Messages.RuntimeLaunchConfigurationTab_OptionsGroup);
        Composite comp = new Composite((Composite)group, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(comp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)comp);
        Label profileLabel = new Label(comp, 0);
        profileLabel.setText(Messages.RuntimeLaunchConfigurationTab_ProfileLabel);
        GridDataFactory.swtDefaults().applyTo((Control)profileLabel);
        this.profileCombo = new Combo(comp, 12);
        this.profileCombo.setItems((String[])DeviceManagementInteractorFactory.INSTANCE.getAvailableProfileNames().toArray(String[]::new));
        this.profileCombo.addModifyListener(e -> this.updateLaunchConfigurationDialog());
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.profileCombo);
        Label deviceTypeLabel = new Label(comp, 0);
        deviceTypeLabel.setText(Messages.RuntimeLaunchConfigurationTab_DeviceTypeLabel);
        GridDataFactory.swtDefaults().applyTo((Control)deviceTypeLabel);
        this.deviceTypeText = new Text(comp, 2048);
        this.deviceTypeText.setEditable(false);
        this.deviceTypeText.setMessage(Messages.RuntimeLaunchConfigurationTab_DeviceTypeMessage);
        this.deviceTypeText.addModifyListener(e -> this.scheduleUpdateJob());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.deviceTypeText);
        Button deviceTypeButton = new Button(comp, 2048);
        deviceTypeButton.setText(Messages.RuntimeLaunchConfigurationTab_Dots);
        deviceTypeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleDeviceTypeButtonSelected()));
        GridDataFactory.swtDefaults().applyTo((Control)deviceTypeButton);
        Label resourceTypeLabel = new Label(comp, 0);
        resourceTypeLabel.setText(Messages.RuntimeLaunchConfigurationTab_ResourceTypeLabel);
        GridDataFactory.swtDefaults().applyTo((Control)resourceTypeLabel);
        this.resourceTypeText = new Text(comp, 2048);
        this.resourceTypeText.setEditable(false);
        this.resourceTypeText.setMessage(Messages.RuntimeLaunchConfigurationTab_ResourceTypeMessage);
        this.resourceTypeText.addModifyListener(e -> this.scheduleUpdateJob());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.resourceTypeText);
        Button resourceTypeButton = new Button(comp, 2048);
        resourceTypeButton.setText(Messages.RuntimeLaunchConfigurationTab_Dots);
        resourceTypeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleResourceTypeButtonSelected()));
        GridDataFactory.swtDefaults().applyTo((Control)resourceTypeButton);
        return group;
    }

    private void handleDeviceTypeButtonSelected() {
        TypeNode node;
        Object object;
        DataTypeTreeSelectionDialog dialog = new DataTypeTreeSelectionDialog(this.getShell(), (ITreeContentProvider)DeviceTypeSelectionTreeContentProvider.INSTANCE);
        dialog.setTitle(Messages.RuntimeLaunchConfigurationTab_DeviceTypeDialogTitle);
        dialog.setMessage(Messages.RuntimeLaunchConfigurationTab_DeviceTypeDialogMessage);
        dialog.setInput((Object)this.getTypeLibrary());
        dialog.setAllowMultiple(false);
        if (dialog.open() == 0 && (object = dialog.getFirstResult()) instanceof TypeNode && !(node = (TypeNode)object).isDirectory()) {
            this.deviceTypeText.setText(node.getFullName());
            this.scheduleUpdateJob();
        }
    }

    private void handleResourceTypeButtonSelected() {
        TypeNode node;
        Object object;
        DataTypeTreeSelectionDialog dialog = new DataTypeTreeSelectionDialog(this.getShell(), (ITreeContentProvider)ResourceTypeSelectionTreeContentProvider.INSTANCE);
        dialog.setTitle(Messages.RuntimeLaunchConfigurationTab_ResourceTypeDialogTitle);
        dialog.setMessage(Messages.RuntimeLaunchConfigurationTab_ResourceTypeDialogMessage);
        dialog.setInput((Object)this.getTypeLibrary());
        dialog.setAllowMultiple(false);
        if (dialog.open() == 0 && (object = dialog.getFirstResult()) instanceof TypeNode && !(node = (TypeNode)object).isDirectory()) {
            this.resourceTypeText.setText(node.getFullName());
            this.scheduleUpdateJob();
        }
    }

    protected TypeLibrary getTypeLibrary() {
        IResource targetResource = this.getTargetResource();
        if (targetResource != null) {
            return TypeLibraryManager.INSTANCE.getTypeLibrary(targetResource.getProject());
        }
        return null;
    }

    protected IResource getTargetResource() {
        MainLaunchConfigurationTab mainLaunchConfigurationTab = this.getMainLaunchConfigurationTab();
        if (mainLaunchConfigurationTab != null) {
            return mainLaunchConfigurationTab.getResource();
        }
        return null;
    }

    protected MainLaunchConfigurationTab getMainLaunchConfigurationTab() {
        return Stream.of(this.getLaunchConfigurationDialog().getTabs()).filter(MainLaunchConfigurationTab.class::isInstance).findAny().orElse(null);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.removeAttribute("org.eclipse.fordiac.ide.deployment.eval.MGR_ID");
        configuration.removeAttribute("org.eclipse.fordiac.ide.deployment.eval.DEVICE_PROFILE");
        configuration.removeAttribute("org.eclipse.fordiac.ide.deployment.eval.DEVICE_TYPE");
        configuration.removeAttribute("org.eclipse.fordiac.ide.deployment.evalRESOURCE_TYPE");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.runtimeText.setText(configuration.getAttribute("org.eclipse.fordiac.ide.deployment.eval.MGR_ID", "\"localhost:61499\""));
            this.profileCombo.setText(configuration.getAttribute("org.eclipse.fordiac.ide.deployment.eval.DEVICE_PROFILE", "HOLOBLOC"));
            this.deviceTypeText.setText(configuration.getAttribute("org.eclipse.fordiac.ide.deployment.eval.DEVICE_TYPE", "FORTE_PC"));
            this.resourceTypeText.setText(configuration.getAttribute("org.eclipse.fordiac.ide.deployment.evalRESOURCE_TYPE", "EMB_RES"));
        }
        catch (CoreException e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)((Object)e));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.fordiac.ide.deployment.eval.MGR_ID", this.runtimeText.getText());
        configuration.setAttribute("org.eclipse.fordiac.ide.deployment.eval.DEVICE_PROFILE", this.profileCombo.getText());
        configuration.setAttribute("org.eclipse.fordiac.ide.deployment.eval.DEVICE_TYPE", this.deviceTypeText.getText());
        configuration.setAttribute("org.eclipse.fordiac.ide.deployment.evalRESOURCE_TYPE", this.resourceTypeText.getText());
    }

    public String getName() {
        return Messages.RuntimeLaunchConfigurationTab_RuntimeTabName;
    }

    public String getId() {
        return ID;
    }
}

