/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextalgorithm.util;

import com.google.inject.Inject;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.STMethod;
import org.eclipse.fordiac.ide.structuredtextalgorithm.services.STAlgorithmGrammarAccess;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithmSource;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithmSourceElement;
import org.eclipse.fordiac.ide.structuredtextalgorithm.util.STAlgorithmPartition;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.util.STAbstractCorePartitioner;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCorePartition;
import org.eclipse.fordiac.ide.structuredtextcore.util.STRecoveringPartitioner;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;

public class STAlgorithmPartitioner
extends STRecoveringPartitioner<ICallable> {
    @Inject
    private STAlgorithmGrammarAccess grammarAccess;

    public String combine(LibraryElement libraryElement) {
        if (libraryElement instanceof BaseFBType) {
            BaseFBType baseFBType = (BaseFBType)libraryElement;
            return this.combine(baseFBType);
        }
        return "";
    }

    protected String combine(BaseFBType baseFBType) {
        return this.combine((List<? extends ICallable>)baseFBType.getCallables());
    }

    protected String combine(List<? extends ICallable> callables) {
        return callables.stream().map(this::toSTText).collect(Collectors.joining());
    }

    protected String toSTText(ICallable callable) {
        ICallable iCallable = callable;
        Objects.requireNonNull(iCallable);
        ICallable iCallable2 = iCallable;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{STAlgorithm.class, STMethod.class}, (Object)iCallable2, n)) {
            case 0 -> {
                STAlgorithm algorithm = (STAlgorithm)iCallable2;
                yield this.toSTText(algorithm);
            }
            case 1 -> {
                STMethod method = (STMethod)iCallable2;
                yield STAlgorithmPartitioner.toSTText(method);
            }
            default -> "";
        };
    }

    protected String toSTText(STAlgorithm algorithm) {
        String text = algorithm.getText();
        if (text.contains(this.grammarAccess.getSTAlgorithmAccess().getALGORITHMKeyword_0().getValue()) || text.contains(this.grammarAccess.getSTAlgorithmAccess().getEND_ALGORITHMKeyword_3().getValue())) {
            return text;
        }
        return STAlgorithmPartitioner.generateAlgorithmDefinition(algorithm);
    }

    protected static String generateAlgorithmDefinition(STAlgorithm algorithm) {
        StringBuilder builder = new StringBuilder();
        builder.append("ALGORITHM ");
        builder.append(algorithm.getName());
        builder.append("\n");
        builder.append(algorithm.getText());
        builder.append("\n");
        builder.append("END_ALGORITHM");
        builder.append("\n");
        builder.append("\n");
        return builder.toString();
    }

    protected static String toSTText(STMethod method) {
        return method.getText();
    }

    public Optional<STCorePartition> partition(XtextResource resource) {
        if (resource.getEntryPoint() != null && resource.getEntryPoint() != this.grammarAccess.getSTAlgorithmSourceRule()) {
            return Optional.empty();
        }
        EObject source = (EObject)resource.getContents().get(0);
        if (source instanceof STAlgorithmSource) {
            STAlgorithmSource algorithmSource = (STAlgorithmSource)source;
            return this.partition(algorithmSource);
        }
        return this.emergencyPartition(resource);
    }

    public Optional<STCorePartition> partition(STAlgorithmSource source) {
        try {
            ICompositeNode node = NodeModelUtils.getNode((EObject)source);
            List result = source.getElements().stream().map(this::convertSourceElement).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
            this.handleLostAndFound(node.getRootNode(), (List)source.getElements(), result);
            STAlgorithmPartitioner.handleDuplicates((List)result);
            return Optional.of(new STAlgorithmPartition(null, Collections.emptyList(), node.getText(), result));
        }
        catch (Exception e) {
            return this.emergencyPartition((STSource)source);
        }
    }

    protected ICallable convertSourceElement(STAlgorithmSourceElement element) {
        STAlgorithmSourceElement sTAlgorithmSourceElement = element;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithm.class, org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod.class}, (Object)sTAlgorithmSourceElement, n)) {
            case 0 -> {
                org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithm algorithm = (org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithm)sTAlgorithmSourceElement;
                yield this.convertSourceElement(algorithm);
            }
            case 1 -> {
                org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod method = (org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod)sTAlgorithmSourceElement;
                yield this.convertSourceElement(method);
            }
            default -> null;
        };
    }

    protected ICallable convertSourceElement(org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithm algorithm) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)algorithm);
        if (node == null || algorithm.getName() == null) {
            return null;
        }
        STAlgorithm result = LibraryElementFactory.eINSTANCE.createSTAlgorithm();
        result.setName(algorithm.getName());
        String comment = this.getDocumentationProvider().getDocumentation((EObject)algorithm);
        if (comment != null) {
            result.setComment(comment);
        }
        result.setText(node.getText());
        return result;
    }

    protected STMethod convertSourceElement(org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod method) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)method);
        if (node == null || method.getName() == null) {
            return null;
        }
        STMethod result = LibraryElementFactory.eINSTANCE.createSTMethod();
        result.setName(method.getName());
        String comment = this.getDocumentationProvider().getDocumentation((EObject)method);
        if (comment != null) {
            result.setComment(comment);
        }
        method.getInputParameters().stream().map(STVarDeclaration.class::cast).filter(STAbstractCorePartitioner::isValidParameter).map(arg_0 -> ((STAlgorithmPartitioner)this).convertInputParameter(arg_0)).forEachOrdered(arg_0 -> result.getInputParameters().add(arg_0));
        method.getOutputParameters().stream().map(STVarDeclaration.class::cast).filter(STAbstractCorePartitioner::isValidParameter).map(arg_0 -> ((STAlgorithmPartitioner)this).convertOutputParameter(arg_0)).forEachOrdered(arg_0 -> result.getOutputParameters().add(arg_0));
        method.getInOutParameters().stream().map(STVarDeclaration.class::cast).filter(STAbstractCorePartitioner::isValidParameter).map(arg_0 -> ((STAlgorithmPartitioner)this).convertInOutParameter(arg_0)).forEachOrdered(arg_0 -> result.getInOutParameters().add(arg_0));
        result.setReturnType(STAlgorithmPartitioner.resolveDataType((INamedElement)method.getReturnType(), (EObject)method, null));
        result.setText(node.getText());
        return result;
    }

    protected STCorePartition createEmergencyPartition(String originalSource) {
        return new STAlgorithmPartition(null, Collections.emptyList(), originalSource, List.of(this.createLostAndFound(originalSource, 0)));
    }

    protected STMethod createLostAndFound(String content, int index) {
        STMethod method = LibraryElementFactory.eINSTANCE.createSTMethod();
        method.setName(STAlgorithmPartitioner.generateLostAndFoundName((int)index));
        method.setComment(STAlgorithmPartitioner.generateLostAndFoundComment((int)index));
        method.setText(content);
        return method;
    }

    protected void appendText(ICallable callable, String text) {
        ICallable iCallable = callable;
        Objects.requireNonNull(iCallable);
        ICallable iCallable2 = iCallable;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{STAlgorithm.class, STMethod.class}, (Object)iCallable2, n)) {
            case 0: {
                STAlgorithm algorithm = (STAlgorithm)iCallable2;
                algorithm.setText(algorithm.getText() + text);
                break;
            }
            case 1: {
                STMethod method = (STMethod)iCallable2;
                method.setText(method.getText() + text);
                break;
            }
        }
    }
}

