/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.ant.org.apache.http.impl.client;

import org.eclipse.aether.internal.ant.org.apache.http.HttpVersion;
import org.eclipse.aether.internal.ant.org.apache.http.annotation.ThreadSafe;
import org.eclipse.aether.internal.ant.org.apache.http.client.protocol.RequestAddCookies;
import org.eclipse.aether.internal.ant.org.apache.http.client.protocol.RequestAuthCache;
import org.eclipse.aether.internal.ant.org.apache.http.client.protocol.RequestClientConnControl;
import org.eclipse.aether.internal.ant.org.apache.http.client.protocol.RequestDefaultHeaders;
import org.eclipse.aether.internal.ant.org.apache.http.client.protocol.RequestProxyAuthentication;
import org.eclipse.aether.internal.ant.org.apache.http.client.protocol.RequestTargetAuthentication;
import org.eclipse.aether.internal.ant.org.apache.http.client.protocol.ResponseProcessCookies;
import org.eclipse.aether.internal.ant.org.apache.http.conn.ClientConnectionManager;
import org.eclipse.aether.internal.ant.org.apache.http.impl.client.AbstractHttpClient;
import org.eclipse.aether.internal.ant.org.apache.http.params.HttpConnectionParams;
import org.eclipse.aether.internal.ant.org.apache.http.params.HttpParams;
import org.eclipse.aether.internal.ant.org.apache.http.params.HttpProtocolParams;
import org.eclipse.aether.internal.ant.org.apache.http.params.SyncBasicHttpParams;
import org.eclipse.aether.internal.ant.org.apache.http.protocol.BasicHttpProcessor;
import org.eclipse.aether.internal.ant.org.apache.http.protocol.HTTP;
import org.eclipse.aether.internal.ant.org.apache.http.protocol.RequestContent;
import org.eclipse.aether.internal.ant.org.apache.http.protocol.RequestExpectContinue;
import org.eclipse.aether.internal.ant.org.apache.http.protocol.RequestTargetHost;
import org.eclipse.aether.internal.ant.org.apache.http.protocol.RequestUserAgent;
import org.eclipse.aether.internal.ant.org.apache.http.util.VersionInfo;

@ThreadSafe
public class DefaultHttpClient
extends AbstractHttpClient {
    public DefaultHttpClient(ClientConnectionManager conman, HttpParams params) {
        super(conman, params);
    }

    public DefaultHttpClient(ClientConnectionManager conman) {
        super(conman, null);
    }

    public DefaultHttpClient(HttpParams params) {
        super(null, params);
    }

    public DefaultHttpClient() {
        super(null, null);
    }

    protected HttpParams createHttpParams() {
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        DefaultHttpClient.setDefaultHttpParams(params);
        return params;
    }

    public static void setDefaultHttpParams(HttpParams params) {
        HttpProtocolParams.setVersion(params, HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset(params, HTTP.DEF_CONTENT_CHARSET.name());
        HttpConnectionParams.setTcpNoDelay(params, true);
        HttpConnectionParams.setSocketBufferSize(params, 8192);
        VersionInfo vi = VersionInfo.loadVersionInfo("org.eclipse.aether.internal.ant.org.apache.http.client", DefaultHttpClient.class.getClassLoader());
        String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
        HttpProtocolParams.setUserAgent(params, "Apache-HttpClient/" + release + " (java 1.5)");
    }

    protected BasicHttpProcessor createHttpProcessor() {
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor(new RequestDefaultHeaders());
        httpproc.addInterceptor(new RequestContent());
        httpproc.addInterceptor(new RequestTargetHost());
        httpproc.addInterceptor(new RequestClientConnControl());
        httpproc.addInterceptor(new RequestUserAgent());
        httpproc.addInterceptor(new RequestExpectContinue());
        httpproc.addInterceptor(new RequestAddCookies());
        httpproc.addInterceptor(new ResponseProcessCookies());
        httpproc.addInterceptor(new RequestAuthCache());
        httpproc.addInterceptor(new RequestTargetAuthentication());
        httpproc.addInterceptor(new RequestProxyAuthentication());
        return httpproc;
    }
}

