/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.ant.org.apache.http.protocol;

import java.io.IOException;
import org.eclipse.aether.internal.ant.org.apache.http.HttpException;
import org.eclipse.aether.internal.ant.org.apache.http.HttpRequest;
import org.eclipse.aether.internal.ant.org.apache.http.HttpRequestInterceptor;
import org.eclipse.aether.internal.ant.org.apache.http.annotation.Immutable;
import org.eclipse.aether.internal.ant.org.apache.http.params.HttpProtocolParams;
import org.eclipse.aether.internal.ant.org.apache.http.protocol.HttpContext;

@Immutable
public class RequestUserAgent
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        String useragent;
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (!request.containsHeader("User-Agent") && (useragent = HttpProtocolParams.getUserAgent(request.getParams())) != null) {
            request.addHeader("User-Agent", useragent);
        }
    }
}

