/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.ant.org.apache.maven.model.building;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.aether.internal.ant.org.apache.maven.model.building.ModelSource2;

public class FileModelSource
implements ModelSource2 {
    private final File pomFile;

    public FileModelSource(File pomFile) {
        if (pomFile == null) {
            throw new IllegalArgumentException("no POM file specified");
        }
        this.pomFile = pomFile.getAbsoluteFile();
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.pomFile);
    }

    public String getLocation() {
        return this.pomFile.getPath();
    }

    public File getPomFile() {
        return this.pomFile;
    }

    public String toString() {
        return this.getLocation();
    }

    public ModelSource2 getRelatedSource(String relPath) {
        relPath = relPath.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        File relatedPom = new File(this.pomFile.getParentFile(), relPath);
        if (relatedPom.isDirectory()) {
            relatedPom = new File(relatedPom, "pom.xml");
        }
        if (relatedPom.isFile() && relatedPom.canRead()) {
            return new FileModelSource(new File(relatedPom.toURI().normalize()));
        }
        return null;
    }

    public URI getLocationURI() {
        return this.pomFile.toURI();
    }
}

