/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.ant.org.apache.maven.repository.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.aether.internal.ant.org.apache.maven.repository.internal.LocalSnapshotMetadata;
import org.eclipse.aether.internal.ant.org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.ant.org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.ant.org.eclipse.aether.impl.MetadataGenerator;
import org.eclipse.aether.internal.ant.org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.internal.ant.org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.internal.ant.org.eclipse.aether.util.ConfigUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalSnapshotMetadataGenerator
implements MetadataGenerator {
    private Map<Object, LocalSnapshotMetadata> snapshots;
    private final boolean legacyFormat;

    public LocalSnapshotMetadataGenerator(RepositorySystemSession session, InstallRequest request) {
        this.legacyFormat = ConfigUtils.getBoolean(session.getConfigProperties(), false, "maven.metadata.legacy");
        this.snapshots = new LinkedHashMap<Object, LocalSnapshotMetadata>();
    }

    @Override
    public Collection<? extends Metadata> prepare(Collection<? extends Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if (!artifact.isSnapshot()) continue;
            Object key = LocalSnapshotMetadata.getKey(artifact);
            LocalSnapshotMetadata snapshotMetadata = this.snapshots.get(key);
            if (snapshotMetadata == null) {
                snapshotMetadata = new LocalSnapshotMetadata(artifact, this.legacyFormat);
                this.snapshots.put(key, snapshotMetadata);
            }
            snapshotMetadata.bind(artifact);
        }
        return Collections.emptyList();
    }

    @Override
    public Artifact transformArtifact(Artifact artifact) {
        return artifact;
    }

    @Override
    public Collection<? extends Metadata> finish(Collection<? extends Artifact> artifacts) {
        return this.snapshots.values();
    }
}

