/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.ant.org.apache.maven.settings.building;

import org.eclipse.aether.internal.ant.org.apache.maven.settings.building.SettingsProblem;

public class DefaultSettingsProblem
implements SettingsProblem {
    private final String source;
    private final int lineNumber;
    private final int columnNumber;
    private final String message;
    private final Exception exception;
    private final SettingsProblem.Severity severity;

    public DefaultSettingsProblem(String message, SettingsProblem.Severity severity, String source, int lineNumber, int columnNumber, Exception exception) {
        this.message = message;
        this.severity = severity != null ? severity : SettingsProblem.Severity.ERROR;
        this.source = source != null ? source : "";
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.exception = exception;
    }

    public String getSource() {
        return this.source;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String getLocation() {
        StringBuilder buffer = new StringBuilder(256);
        if (this.getSource().length() > 0) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(this.getSource());
        }
        if (this.getLineNumber() > 0) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("line ").append(this.getLineNumber());
        }
        if (this.getColumnNumber() > 0) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("column ").append(this.getColumnNumber());
        }
        return buffer.toString();
    }

    public Exception getException() {
        return this.exception;
    }

    public String getMessage() {
        String msg;
        if (this.message != null && this.message.length() > 0) {
            msg = this.message;
        } else {
            msg = this.exception.getMessage();
            if (msg == null) {
                msg = "";
            }
        }
        return msg;
    }

    public SettingsProblem.Severity getSeverity() {
        return this.severity;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("[").append((Object)this.getSeverity()).append("] ");
        buffer.append(this.getMessage());
        buffer.append(" @ ").append(this.getLocation());
        return buffer.toString();
    }
}

