/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.ant.org.apache.maven.settings.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.eclipse.aether.internal.ant.org.apache.maven.settings.Settings;
import org.eclipse.aether.internal.ant.org.apache.maven.settings.io.SettingsParseException;
import org.eclipse.aether.internal.ant.org.apache.maven.settings.io.SettingsReader;
import org.eclipse.aether.internal.ant.org.apache.maven.settings.io.xpp3.SettingsXpp3Reader;
import org.eclipse.aether.internal.ant.org.codehaus.plexus.component.annotations.Component;
import org.eclipse.aether.internal.ant.org.codehaus.plexus.util.IOUtil;
import org.eclipse.aether.internal.ant.org.codehaus.plexus.util.ReaderFactory;
import org.eclipse.aether.internal.ant.org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=SettingsReader.class)
public class DefaultSettingsReader
implements SettingsReader {
    @Override
    public Settings read(File input, Map<String, ?> options) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input file missing");
        }
        Settings settings = this.read(ReaderFactory.newXmlReader(input), options);
        return settings;
    }

    @Override
    public Settings read(Reader input, Map<String, ?> options) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input reader missing");
        }
        try {
            SettingsXpp3Reader r = new SettingsXpp3Reader();
            Settings settings = r.read(input, this.isStrict(options));
            return settings;
        }
        catch (XmlPullParserException e) {
            throw new SettingsParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        finally {
            IOUtil.close(input);
        }
    }

    @Override
    public Settings read(InputStream input, Map<String, ?> options) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input stream missing");
        }
        try {
            SettingsXpp3Reader r = new SettingsXpp3Reader();
            Settings settings = r.read(input, this.isStrict(options));
            return settings;
        }
        catch (XmlPullParserException e) {
            throw new SettingsParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        finally {
            IOUtil.close(input);
        }
    }

    private boolean isStrict(Map<String, ?> options) {
        Object value = options != null ? (Object)options.get("org.eclipse.aether.internal.ant.org.apache.maven.settings.io.isStrict") : null;
        return value == null || Boolean.parseBoolean(value.toString());
    }
}

