/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.ant.org.codehaus.plexus.interpolation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.aether.internal.ant.org.codehaus.plexus.interpolation.InterpolationCycleException;
import org.eclipse.aether.internal.ant.org.codehaus.plexus.interpolation.InterpolationException;
import org.eclipse.aether.internal.ant.org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.eclipse.aether.internal.ant.org.codehaus.plexus.interpolation.Interpolator;
import org.eclipse.aether.internal.ant.org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.eclipse.aether.internal.ant.org.codehaus.plexus.interpolation.SimpleRecursionInterceptor;
import org.eclipse.aether.internal.ant.org.codehaus.plexus.interpolation.ValueSource;

public class StringSearchInterpolator
implements Interpolator {
    private Map existingAnswers = new HashMap();
    private List valueSources = new ArrayList();
    private List postProcessors = new ArrayList();
    private boolean cacheAnswers = false;
    public static final String DEFAULT_START_EXPR = "${";
    public static final String DEFAULT_END_EXPR = "}";
    private String startExpr;
    private String endExpr;
    private String escapeString;

    public StringSearchInterpolator() {
        this.startExpr = DEFAULT_START_EXPR;
        this.endExpr = DEFAULT_END_EXPR;
    }

    public StringSearchInterpolator(String startExpr, String endExpr) {
        this.startExpr = startExpr;
        this.endExpr = endExpr;
    }

    public void addValueSource(ValueSource valueSource) {
        this.valueSources.add(valueSource);
    }

    public void removeValuesSource(ValueSource valueSource) {
        this.valueSources.remove(valueSource);
    }

    public void addPostProcessor(InterpolationPostProcessor postProcessor) {
        this.postProcessors.add(postProcessor);
    }

    public void removePostProcessor(InterpolationPostProcessor postProcessor) {
        this.postProcessors.remove(postProcessor);
    }

    public String interpolate(String input, String thisPrefixPattern) throws InterpolationException {
        return this.interpolate(input, new SimpleRecursionInterceptor());
    }

    public String interpolate(String input, String thisPrefixPattern, RecursionInterceptor recursionInterceptor) throws InterpolationException {
        return this.interpolate(input, recursionInterceptor);
    }

    public String interpolate(String input) throws InterpolationException {
        return this.interpolate(input, new SimpleRecursionInterceptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String interpolate(String input, RecursionInterceptor recursionInterceptor) throws InterpolationException {
        try {
            String string = this.interpolate(input, recursionInterceptor, new HashSet());
            return string;
        }
        finally {
            if (!this.cacheAnswers) {
                this.existingAnswers.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String interpolate(String input, RecursionInterceptor recursionInterceptor, Set unresolvable) throws InterpolationException {
        if (input == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(input.length() * 2);
        int startIdx = -1;
        int endIdx = -1;
        while ((startIdx = input.indexOf(this.startExpr, endIdx + 1)) > -1) {
            result.append(input.substring(endIdx + 1, startIdx));
            endIdx = input.indexOf(this.endExpr, startIdx + 1);
            if (endIdx < 0) break;
            String wholeExpr = input.substring(startIdx, endIdx + this.endExpr.length());
            String realExpr = wholeExpr.substring(this.startExpr.length(), wholeExpr.length() - this.endExpr.length());
            if (startIdx >= 0 && this.escapeString != null && this.escapeString.length() > 0) {
                String escape;
                int startEscapeIdx;
                int n = startEscapeIdx = startIdx == 0 ? 0 : startIdx - this.escapeString.length();
                if (startEscapeIdx >= 0 && (escape = input.substring(startEscapeIdx, startIdx)) != null && this.escapeString.equals(escape)) {
                    result.append(wholeExpr);
                    result.replace(startEscapeIdx, startEscapeIdx + this.escapeString.length(), "");
                    continue;
                }
            }
            boolean resolved = false;
            if (!unresolvable.contains(wholeExpr)) {
                if (realExpr.startsWith(".")) {
                    realExpr = realExpr.substring(1);
                }
                if (recursionInterceptor.hasRecursiveExpression(realExpr)) {
                    throw new InterpolationCycleException(recursionInterceptor, realExpr, wholeExpr);
                }
                recursionInterceptor.expressionResolutionStarted(realExpr);
                try {
                    Object value = this.existingAnswers.get(realExpr);
                    Object bestAnswer = null;
                    Iterator it = this.valueSources.iterator();
                    while (it.hasNext() && value == null) {
                        ValueSource vs = (ValueSource)it.next();
                        value = vs.getValue(realExpr);
                        if (value == null || value.toString().indexOf(wholeExpr) <= -1) continue;
                        bestAnswer = value;
                        value = null;
                    }
                    if (value == null && bestAnswer != null) {
                        throw new InterpolationCycleException(recursionInterceptor, realExpr, wholeExpr);
                    }
                    if (value != null) {
                        value = this.interpolate(String.valueOf(value), recursionInterceptor, unresolvable);
                        if (this.postProcessors != null && !this.postProcessors.isEmpty()) {
                            for (InterpolationPostProcessor postProcessor : this.postProcessors) {
                                Object newVal = postProcessor.execute(realExpr, value);
                                if (newVal == null) continue;
                                value = newVal;
                                break;
                            }
                        }
                        result.append(String.valueOf(value));
                        resolved = true;
                    } else {
                        unresolvable.add(wholeExpr);
                    }
                }
                finally {
                    recursionInterceptor.expressionResolutionFinished(realExpr);
                }
            }
            if (!resolved) {
                result.append(wholeExpr);
            }
            if (endIdx <= -1) continue;
            endIdx += this.endExpr.length() - 1;
        }
        if (endIdx == -1 && startIdx > -1) {
            result.append(input.substring(startIdx, input.length()));
        } else if (endIdx < input.length()) {
            result.append(input.substring(endIdx + 1, input.length()));
        }
        return result.toString();
    }

    public List getFeedback() {
        ArrayList messages = new ArrayList();
        for (ValueSource vs : this.valueSources) {
            List feedback = vs.getFeedback();
            if (feedback == null || feedback.isEmpty()) continue;
            messages.addAll(feedback);
        }
        return messages;
    }

    public void clearFeedback() {
        for (ValueSource vs : this.valueSources) {
            vs.clearFeedback();
        }
    }

    public boolean isCacheAnswers() {
        return this.cacheAnswers;
    }

    public void setCacheAnswers(boolean cacheAnswers) {
        this.cacheAnswers = cacheAnswers;
    }

    public void clearAnswers() {
        this.existingAnswers.clear();
    }

    public String getEscapeString() {
        return this.escapeString;
    }

    public void setEscapeString(String escapeString) {
        this.escapeString = escapeString;
    }
}

