/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.ant.org.eclipse.aether.connector.basic;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.eclipse.aether.internal.ant.org.eclipse.aether.connector.basic.ChecksumCalculator;
import org.eclipse.aether.internal.ant.org.eclipse.aether.spi.connector.checksum.ChecksumPolicy;
import org.eclipse.aether.internal.ant.org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.eclipse.aether.internal.ant.org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.internal.ant.org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.internal.ant.org.eclipse.aether.transfer.ChecksumFailureException;
import org.eclipse.aether.internal.ant.org.eclipse.aether.util.ChecksumUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ChecksumValidator {
    private final Logger logger;
    private final File dataFile;
    private final Collection<File> tempFiles;
    private final FileProcessor fileProcessor;
    private final ChecksumFetcher checksumFetcher;
    private final ChecksumPolicy checksumPolicy;
    private final Collection<RepositoryLayout.Checksum> checksums;
    private final Map<File, Object> checksumFiles;

    public ChecksumValidator(Logger logger, File dataFile, FileProcessor fileProcessor, ChecksumFetcher checksumFetcher, ChecksumPolicy checksumPolicy, Collection<RepositoryLayout.Checksum> checksums) {
        this.logger = logger;
        this.dataFile = dataFile;
        this.tempFiles = new HashSet<File>();
        this.fileProcessor = fileProcessor;
        this.checksumFetcher = checksumFetcher;
        this.checksumPolicy = checksumPolicy;
        this.checksums = checksums;
        this.checksumFiles = new HashMap<File, Object>();
    }

    public ChecksumCalculator newChecksumCalculator(File targetFile) {
        if (this.checksumPolicy != null) {
            return ChecksumCalculator.newInstance(targetFile, this.checksums);
        }
        return null;
    }

    public void validate(Map<String, ?> actualChecksums, Map<String, ?> inlinedChecksums) throws ChecksumFailureException {
        if (this.checksumPolicy == null) {
            return;
        }
        if (inlinedChecksums != null && this.validateInlinedChecksums(actualChecksums, inlinedChecksums)) {
            return;
        }
        if (this.validateExternalChecksums(actualChecksums)) {
            return;
        }
        this.checksumPolicy.onNoMoreChecksums();
    }

    private boolean validateInlinedChecksums(Map<String, ?> actualChecksums, Map<String, ?> inlinedChecksums) throws ChecksumFailureException {
        for (Map.Entry<String, ?> entry : inlinedChecksums.entrySet()) {
            String algo = entry.getKey();
            Object calculated = actualChecksums.get(algo);
            if (!(calculated instanceof String)) continue;
            String actual = String.valueOf(calculated);
            String expected = entry.getValue().toString();
            this.checksumFiles.put(this.getChecksumFile(algo), expected);
            if (!ChecksumValidator.isEqualChecksum(expected, actual)) {
                this.checksumPolicy.onChecksumMismatch(algo, 1, new ChecksumFailureException(expected, actual));
                continue;
            }
            if (!this.checksumPolicy.onChecksumMatch(algo, 1)) continue;
            return true;
        }
        return false;
    }

    private boolean validateExternalChecksums(Map<String, ?> actualChecksums) throws ChecksumFailureException {
        for (RepositoryLayout.Checksum checksum : this.checksums) {
            String algo = checksum.getAlgorithm();
            Object calculated = actualChecksums.get(algo);
            if (calculated instanceof Exception) {
                this.checksumPolicy.onChecksumError(algo, 0, new ChecksumFailureException((Exception)calculated));
                continue;
            }
            try {
                File tmp;
                File checksumFile;
                block8: {
                    checksumFile = this.getChecksumFile(checksum.getAlgorithm());
                    tmp = this.createTempFile(checksumFile);
                    try {
                        if (!this.checksumFetcher.fetchChecksum(checksum.getLocation(), tmp)) {
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        this.checksumPolicy.onChecksumError(algo, 0, new ChecksumFailureException(e));
                    }
                    continue;
                }
                String actual = String.valueOf(calculated);
                String expected = ChecksumUtils.read(tmp);
                this.checksumFiles.put(checksumFile, tmp);
                if (!ChecksumValidator.isEqualChecksum(expected, actual)) {
                    this.checksumPolicy.onChecksumMismatch(algo, 0, new ChecksumFailureException(expected, actual));
                    continue;
                }
                if (!this.checksumPolicy.onChecksumMatch(algo, 0)) continue;
                return true;
            }
            catch (IOException e) {
                this.checksumPolicy.onChecksumError(algo, 0, new ChecksumFailureException(e));
            }
        }
        return false;
    }

    private static boolean isEqualChecksum(String expected, String actual) {
        return expected.equalsIgnoreCase(actual);
    }

    private File getChecksumFile(String algorithm) {
        String ext = algorithm.replace("-", "").toLowerCase(Locale.ENGLISH);
        return new File(this.dataFile.getPath() + '.' + ext);
    }

    private File createTempFile(File path) throws IOException {
        File file = File.createTempFile(path.getName() + "-" + UUID.randomUUID().toString().replace("-", "").substring(0, 8), ".tmp", path.getParentFile());
        this.tempFiles.add(file);
        return file;
    }

    private void clearTempFiles() {
        for (File file : this.tempFiles) {
            if (file.delete() || !file.exists()) continue;
            this.logger.debug("Could not delete temorary file " + file);
        }
        this.tempFiles.clear();
    }

    public void retry() {
        this.checksumPolicy.onTransferRetry();
        this.checksumFiles.clear();
        this.clearTempFiles();
    }

    public boolean handle(ChecksumFailureException exception) {
        return this.checksumPolicy.onTransferChecksumFailure(exception);
    }

    public void commit() {
        for (Map.Entry<File, Object> entry : this.checksumFiles.entrySet()) {
            File checksumFile = entry.getKey();
            Object tmp = entry.getValue();
            try {
                if (tmp instanceof File) {
                    this.fileProcessor.move((File)tmp, checksumFile);
                    this.tempFiles.remove(tmp);
                    continue;
                }
                this.fileProcessor.write(checksumFile, String.valueOf(tmp));
            }
            catch (IOException e) {
                this.logger.debug("Failed to write checksum file " + checksumFile + ": " + e.getMessage(), e);
            }
        }
        this.checksumFiles.clear();
    }

    public void close() {
        this.clearTempFiles();
    }

    static interface ChecksumFetcher {
        public boolean fetchChecksum(URI var1, File var2) throws Exception;
    }
}

