/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.ant.org.eclipse.aether.metadata;

import java.io.File;
import java.util.Map;
import org.eclipse.aether.internal.ant.org.eclipse.aether.metadata.AbstractMetadata;
import org.eclipse.aether.internal.ant.org.eclipse.aether.metadata.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultMetadata
extends AbstractMetadata {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String type;
    private final Metadata.Nature nature;
    private final File file;
    private final Map<String, String> properties;

    public DefaultMetadata(String type, Metadata.Nature nature) {
        this("", "", "", type, nature, null, (File)null);
    }

    public DefaultMetadata(String groupId, String type, Metadata.Nature nature) {
        this(groupId, "", "", type, nature, null, (File)null);
    }

    public DefaultMetadata(String groupId, String artifactId, String type, Metadata.Nature nature) {
        this(groupId, artifactId, "", type, nature, null, (File)null);
    }

    public DefaultMetadata(String groupId, String artifactId, String version, String type, Metadata.Nature nature) {
        this(groupId, artifactId, version, type, nature, null, (File)null);
    }

    public DefaultMetadata(String groupId, String artifactId, String version, String type, Metadata.Nature nature, File file) {
        this(groupId, artifactId, version, type, nature, null, file);
    }

    public DefaultMetadata(String groupId, String artifactId, String version, String type, Metadata.Nature nature, Map<String, String> properties, File file) {
        this.groupId = DefaultMetadata.emptify(groupId);
        this.artifactId = DefaultMetadata.emptify(artifactId);
        this.version = DefaultMetadata.emptify(version);
        this.type = DefaultMetadata.emptify(type);
        if (nature == null) {
            throw new IllegalArgumentException("metadata nature was not specified");
        }
        this.nature = nature;
        this.file = file;
        this.properties = DefaultMetadata.copyProperties(properties);
    }

    DefaultMetadata(String groupId, String artifactId, String version, String type, Metadata.Nature nature, File file, Map<String, String> properties) {
        this.groupId = DefaultMetadata.emptify(groupId);
        this.artifactId = DefaultMetadata.emptify(artifactId);
        this.version = DefaultMetadata.emptify(version);
        this.type = DefaultMetadata.emptify(type);
        this.nature = nature;
        this.file = file;
        this.properties = properties;
    }

    private static String emptify(String str) {
        return str == null ? "" : str;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Metadata.Nature getNature() {
        return this.nature;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }
}

