/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.ant.org.eclipse.aether.transport.file;

import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.internal.ant.org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.ant.org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.internal.ant.org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.internal.ant.org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.internal.ant.org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.internal.ant.org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.internal.ant.org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.internal.ant.org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.internal.ant.org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.internal.ant.org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.internal.ant.org.eclipse.aether.transport.file.FileTransporter;

@Named(value="file")
public final class FileTransporterFactory
implements TransporterFactory,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private float priority;

    public FileTransporterFactory() {
    }

    @Inject
    FileTransporterFactory(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
    }

    public FileTransporterFactory setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, FileTransporter.class);
        return this;
    }

    public float getPriority() {
        return this.priority;
    }

    public FileTransporterFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    public Transporter newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        return new FileTransporter(repository, this.logger);
    }
}

